#include "mbed.h"

PwmOut  led( LED1 );
PwmOut  out( p21 );
Serial  pc( USBTX, USBRX );

#define PWM_CHANGE_STEPS        0.05
#define PERIOD_CHANGE_FACTOR    2.0

int main()
{
    float   period  = 0.001;
    float   pwm     = 0.5;

    printf( "\r\n\r\nPwmOut period test\r\n" );
    printf( "  use arrow key to change parameters : \r\n  left/right for period, up/down for PWM ratio\r\n" );

    out.period( period );
    out = pwm;
    led = pwm;

    printf( "period = %12g sec, pwm = %3.0f\r", period, pwm * 100.0 );
    fflush( stdout );

    while(1) {
        if ( pc.readable() ) {
            switch ( pc.getc() ) {
                case 0x1B :
                    if ( 0x5B == pc.getc() )
                        //  arrow key pressed
                        switch ( pc.getc() ) {
                            case 0x44 : //  left arrow
                                period   /= PERIOD_CHANGE_FACTOR;
                                break;
                            case 0x43 : //  right arrow
                                period   *= PERIOD_CHANGE_FACTOR;
                                break;
                            case 0x41 : //  up arrow
                                pwm += (pwm >= (1 - PWM_CHANGE_STEPS)) ? 0.0 : PWM_CHANGE_STEPS;
                                break;
                            case 0x42 : //  down arrow
                                pwm -= (pwm <= PWM_CHANGE_STEPS) ? 0.0 : PWM_CHANGE_STEPS;
                                break;
                            default :
                                break;
                        }
            }
            out.period( period );
            out = pwm;
            led = pwm;

            printf( "period = %12g sec, pwm = %3.0f\r", period, pwm * 100.0 );
            fflush( stdout );
        }
    }
}

