//  This is a sample/lib collection for the starboard
//  Those libs are from...
//      http://mbed.org/cookbook/Text-LCD                       (New TextLCD lib/sample)
//      http://mbed.org/cookbook/SD-Card-File-System            (latest as of 2010-07-07)
//      http://mbed.org/users/chris/programs/MSCFileSystem_Lib  (USB-strage)
//      http://mbed.org/cookbook/HTTP-Server                    (Ethernet check with HTTP server)
//
//  For the battery supply check, another program 
//  (http://mbed.org/users/nxpfan/programs/RTC_LCD__starboard_orange) can be used
//
//  @nxpfan, 2010-07-07 (Wish upon a Star)

#include "mbed.h"

////////////////////////////////////////
////////    general setting     ////////
////////////////////////////////////////
#define     USE_TextLCD_20x4
#define     USE_FIXED_IP

////////////////////////////////////////
////////    For TextLCD         ////////
////////////////////////////////////////
#include "TextLCD.h"
#ifdef  USE_TextLCD_20x4
TextLCD     lcd( p24, p26, p27, p28, p29, p30, TextLCD::LCD20x4 ); // rs, e, d0-d3
#else
TextLCD     lcd( p24, p26, p27, p28, p29, p30 ); // rs, e, d0-d3
#endif

////////////////////////////////////////
////////    For SD_card         ////////
////////////////////////////////////////
#include "SDFileSystem.h"
SDFileSystem    sd(p5, p6, p7, p13, "sd");  //  mosi, miso, sclk, cs, name
//SDFileSystem  sd(p5, p6, p7, p8,  "sd");  //  (HW modification candidate)

////////////////////////////////////////
////////    For USB storage     ////////
////////////////////////////////////////
#include "MSCFileSystem.h"
MSCFileSystem   usb("usb");

////////////////////////////////////////
////////    For Ethernet test   ////////
////////////////////////////////////////
#include "EthernetNetIf.h"
#include "HTTPServer.h"
#ifdef      USE_FIXED_IP
EthernetNetIf   eth(
    IpAddr(192,168,0,7), //IP Address
    IpAddr(255,255,255,0), //Network Mask
    IpAddr(192,168,0,1), //Gateway
    IpAddr(192,168,0,1)  //DNS
);
#else
EthernetNetIf   eth;
#endif
HTTPServer svr;
LocalFileSystem web("webfs");


void test_TextLCD( void );
void test_file_write( char *title, char *path );
void test_httpserver( void );
int  position( void );

int main() {
    test_TextLCD();
    wait( 1 );
    test_file_write( "SD card", "/sd/testfile.txt" );
    wait( 1 );
    //test_file_write( "USB storage", "/usb/testfile.txt" );
    //wait( 1 );
    test_httpserver();
}


void test_TextLCD( void ) {
    //  TextLCD test

#ifdef  USE_TextLCD_20x4
    lcd.locate( 0, 0 );
    for ( int i = 0, c = '0'; i < 20; i++, c++ )
        lcd.putc( c );

    for ( int i = 0, c = 'A'; i < 20; i++, c++ )
        lcd.putc( c );
            
    for ( int i = 0, c = 'a'; i < 20; i++, c++ )
        lcd.putc( c );
    for ( int i = 0, c = '0' - 10; i < 20; i++, c++ )
        lcd.putc( c );

    wait( 2 );
    lcd.cls();
#endif  //  USE_TextLCD_20x4

    lcd.locate( 0, 0 );
    lcd.printf( "TextLCD: OK?" );
    lcd.locate( 0, 1 );
    lcd.printf( "" );

}

void test_file_write( char *title, char *path ) {
    //  SD card test
    lcd.locate( 0, position() );
    lcd.printf( "%s: ", title );

    FILE *fp = fopen( path, "w" );
    if ( fp == NULL ) {
        lcd.printf( "error" );
        error( "Could not open file for write\n" );
    }
    fprintf( fp, "Hello world, %s!", title );
    fclose( fp );

    lcd.printf( "OK." );
}


void test_httpserver( void ) {
    DigitalOut  led1( LED1 );

    lcd.locate( 0, position() );
    lcd.printf( "HTTP srv: " );

    Base::add_rpc_class<DigitalOut>();

    printf("Setting up...n");
    EthernetErr ethErr = eth.setup();
    if ( ethErr ) {
        lcd.printf( "error" );
        error( "error @ eth.setup()\n" );
    }
    lcd.printf("OK ");

    FSHandler::mount("/webfs", "/"); //Mount /webfs path on web root path

    svr.addHandler<FSHandler>("/"); //Default handler

    svr.bind(80);

    lcd.locate( 5, position() -1 );
    lcd.printf("Listening");

    Timer tm;
    tm.start();
    //Listen indefinitely
    while (true) {
        Net::poll();
        if (tm.read()>.5) {
            led1=!led1; //Show that we are alive
            tm.start();
        }
    }
}


int position( void ) {
    static int  p   = 0;

#ifdef  USE_TextLCD_20x4
    return( ++p % 4 );
#else
    return( ++p % 2 );
#endif
}

