/*
  Update: 21-06-2010
  The basic authentication service for twitter is going down at the end of the week.
  To continue using that program, the code has been updated to use http://supertweet.net which acts as an API proxy.
  Simply visit the website to setup your twitter account for this API.
  See: http://www.supertweet.net/about/documentation
*/

#include "mbed.h"
#include "EthernetNetIf.h"
#include "HTTPClient.h"
#include "TextLCD.h"

TextLCD lcd(p24, p25, p26, p27, p28, p29); // rs, e, d0-d3
//TextLCD     lcd( p24, p26, p27, p28, p29, p30 ); // rs, e, d0-d3

EthernetNetIf eth; 

int main() {

  printf("Init\n");                           lcd.locate( 0, 0 );   lcd.printf("Init           ");
  printf("\r\nSetting up...\r\n");            lcd.locate( 0, 0 );   lcd.printf("Setting up     ");
  
  EthernetErr ethErr = eth.setup();
  if(ethErr)
  {
    printf("Error %d in setup.\n", ethErr);   lcd.locate( 0, 0 );   lcd.printf("error %d", ethErr);
    return -1;
  }
  printf("\r\nSetup OK\r\n");                 lcd.locate( 0, 0 );   lcd.printf("Setup OK       ");

  HTTPClient twitter;
  
  HTTPMap msg;
  
  //msg["status"] = "twitter test AAAA"; //A good example of Key/Value pair use with Web APIs
  LocalFileSystem local("local");
  char   s[256];
  FILE   *fp;
  
  printf("\r\nreading a message file.\r\n");
  
  if(NULL == (fp = fopen("/local/tweet.txt","r")) ) {
    printf("\r\nError: The message file cannot be accessed\r\n");  lcd.locate( 0, 0 );   lcd.printf("File access error");
    return -1;
  }
  
  fgets(s,256,fp);
  fclose(fp);
  
  msg["status"] = s;      lcd.locate( 0, 0 );   lcd.printf("File read done ");
  twitter.basicAuth("USER_ID", "PASSWORD"); //We use basic authentication, replace with you account's parameters
  
  //No need to retieve data sent back by the server
  HTTPResult r = twitter.post("http://api.supertweet.net/1/statuses/update.xml", msg, NULL); 
  if( r == HTTP_OK )
  {
    printf("Tweet sent with success!\n");      lcd.locate( 0, 0 );   lcd.printf("Done           ");
  }
  else
  {
    printf("Problem during tweeting, return code %d\n", r);lcd.locate( 0, 0 );   lcd.printf("Got error      ");
  }
  
  return 0;

}
