//  This code based on 
//  http://mbed.org/users/okano/notebook/nxp_pcf2127a-demo-code/
//  http://mbed.org/users/roen/notebook/real-time/
//
//  2010-07-02  @nxpfan
//  Released under the MIT License: http://mbed.org/license/mit

#include "mbed.h"
#include "TextLCD.h"

TextLCD lcd(p24, p25, p26, p27, p28, p29, p30); // rs, rw, e, d0, d1, d2, d3
Ticker  updater;

void lcd_update()
{
    struct tm   dt, *dtp;
    time_t      t;
    char        s[ 30 ];
    dtp = &dt;

    t       = time( NULL );
    dtp     = localtime( &t );

    strftime( s, 20, "%H:%M:%S", dtp );
    lcd.locate( 0, 0 );
    lcd.printf( "%s", s );

    strftime( s, 20, "%Y/%b/%d(%a)", dtp );
    lcd.locate( 0, 1 );
    lcd.printf( "%s", s );
}

int main() {

    // get the current time from the terminal
    struct tm t;

    if ( 0 == time( NULL ) ) {  // it should return ((time_t)-1) if it is not initialized but...
        lcd.locate( 0, 0 );
        lcd.printf( "please set time from terminal" );

        printf("Enter current date and time:\n");
        printf("YYYY MM DD HH MM SS[enter]\n");
        scanf("%d %d %d %d %d %d", &t.tm_year, &t.tm_mon, &t.tm_mday
              , &t.tm_hour, &t.tm_min, &t.tm_sec);

        // adjust for tm structure required values
        t.tm_year = t.tm_year - 1900;
        t.tm_mon = t.tm_mon - 1;

        // set the time
        set_time(mktime(&t));
    }

    updater.attach(&lcd_update, 1.0);

    while (1)
        ;
}