#include "mbed.h"

#include "PCA9955A.h"
PCA9955A    led_cntlr( p28, p27, 0x02 );    //  SDA, SCL, Slave_address(option)

#define     GRADATION_PERIOD    6.0

int main()
{
    led_cntlr.gradation_group_setting( 0,  1 ); //  Port  1 is assigned to group 0
    led_cntlr.gradation_group_setting( 0,  5 ); //  Port  5 is assigned to group 0
    led_cntlr.gradation_group_setting( 0,  9 ); //  Port  9 is assigned to group 0
    led_cntlr.gradation_group_setting( 0, 13 ); //  Port 13 is assigned to group 0
    led_cntlr.gradation_group_setting( 1,  2 ); //  Port  2 is assigned to group 1
    led_cntlr.gradation_group_setting( 1,  6 ); //  Port  6 is assigned to group 1
    led_cntlr.gradation_group_setting( 1, 10 ); //  Port 10 is assigned to group 1
    led_cntlr.gradation_group_setting( 1, 14 ); //  Port 14 is assigned to group 1
    led_cntlr.gradation_group_setting( 2,  3 ); //  Port  3 is assigned to group 2
    led_cntlr.gradation_group_setting( 2,  7 ); //  Port  7 is assigned to group 2
    led_cntlr.gradation_group_setting( 2, 11 ); //  Port 11 is assigned to group 2
    led_cntlr.gradation_group_setting( 2, 15 ); //  Port 15 is assigned to group 2
    //  Port 0, 4, 8 and 12 are not assigned to any groups
    //  Group 3 has no assigned port

    //  Making same gradation shape to group 0, 1 and 2
    //  The gradation shape will be total 6 seconds cycle including 2 seconds LED-OFF
    float cycle   =
    led_cntlr.gradation_ramp_setting( 0, GRADATION_PERIOD, HOLD_0_00_SEC, HOLD_2_00_SEC, RAMP_UP_DOWN );
    led_cntlr.gradation_ramp_setting( 1, GRADATION_PERIOD, HOLD_0_00_SEC, HOLD_2_00_SEC, RAMP_UP_DOWN );
    led_cntlr.gradation_ramp_setting( 2, GRADATION_PERIOD, HOLD_0_00_SEC, HOLD_2_00_SEC, RAMP_UP_DOWN );

    //  Start group 0
    led_cntlr.gradation_start( 0 );

    //  Start group 1 (after 1/3 cycle delay)
    wait( cycle / 3.0 );
    led_cntlr.gradation_start( 1 );

    //  Start group 2 (after 1/3 cycle delay)
    wait( cycle / 3.0 );
    led_cntlr.gradation_start( 2 );

    //
    //  Now the gradation control for 3 groups are working
    //

    //
    //  Next while loop perform manual control for Rest of ports (0, 4, 8 and 12).
    //  You will see the operation for manual controll ports will be stopped if the I2C line is removed.
    //  But it continues the gradation control if only power supply is available
    //
    while(1) {
        for ( int i = 1; i <= 100; i++ ) {
            led_cntlr.pwm(  0, (float)i / 100.0 );
            led_cntlr.pwm(  4, (float)i / 100.0 );
            led_cntlr.pwm(  8, (float)i / 100.0 );
            led_cntlr.pwm( 12, (float)i / 100.0 );
            wait( 0.01 );
        }
    }
}
