/** A sample app of MARMEX_OB OLED screen drawing library
 *
 *  @author  Tedd
 *  @version 0.51
 *  @date    08-Apr-2011
 *
 *  Released under the MIT License: http://mbed.org/license/mit
 *
 *  MARMEX_OB_oled OLED screen drawing library for mbed
 *  This code has been written based on sample code and advises
 *    from Ochiai-san (Marutsu-Elec). Thank you!
 *
 *  To build this code, "NokiaLCD" and "mbed" libraries are needed to be imported in a project.
 *     NokiaLCD library :  http://mbed.org/users/simon/libraries/NokiaLCD/
 */


#include "mbed.h"
#include "MARMEX_OB_oled.h"

//  oled1 is for MARMEX_OB_oled board on MAPLE slot 1
//  oled1 is for MARMEX_OB_oled board on MAPLE slot 2

MARMEX_OB_oled   oled1( p5, p7,  p8, p30, p11 ); // mosi, sclk, cs, rst, power_control
//MARMEX_OB_oled   oled2( p5, p7, p26, p21, p17 ); // mosi, sclk, cs, rst, power_control


int main() {
    oled1.background( 0x000000 );
    oled1.cls();

    int colorbar_width  = MARMEX_OB_oled::WIDTH / 8;

    for ( int i = 0; i < 8; i++ )
        oled1.fill( colorbar_width * i, 0, colorbar_width, MARMEX_OB_oled::HEIGHT, ((i & 0x4) ? 0xFF0000 : 0x000000) | ((i & 0x2) ? 0x00FF00 : 0x000000) | ((i & 0x1) ? 0x0000FF : 0x000000) );

    oled1.fill(  50,  50,  64,  64, 0xCCCCCC );;

    oled1.locate( 0, 3 );
    oled1.printf( "Hello World!" );
    oled1.locate( 0, 4 );
    oled1.printf( "SPI = %s", MERMEX_OB_SPI_MODE_STR );

    for (int i = 0; i < MARMEX_OB_oled::WIDTH; i++ ) {
        oled1.pixel( i, 80 + sin( (float)i / 5.0 ) * 10, 0x000000 );
    }
}

/*
 *  history:
 *      0.5  (2011-Apr-07) :  initial published version
 *      0.51 (2011-Apr-08) :  minor modification to make the source more consistent (use " MARMEX_OB_oled::HEIGHT" instead of 128)
 */
