/*  A sample code for PCU9669 (and its family) operation sample
 *
 *  @author  Tedd OKANO, NXP Semiconductors
 *  @version 0.5
 *  @date    13-Oct-2011
 *
 *  Released under the MIT License: http://mbed.org/license/mit
 *
 *    An operation sample of PCU9669 I2C bus controller. 
 *  The mbed accesses the PCU9669's parallel port (8 bit address and 8 bit data) using bit-banging. 
 *  The bit-banging is poerformed by PortInOut function of mbed library. 
 *
 *    To make the code porting easier, all codes are partitioned into layers to abstract other parts. 
 *    The mbed specific parts are concentrated in lowest layer: "hardware_abs.*". 
 *    This module may need to be modified when porting. 
 *
 *    All other upper layers are writen in standard-C. 
 *
 *    base code is written from 05-Sep-2011 to 09-Sep-2011.
 *    And demo code has been build on 11-Sep-2011. 
 *    Debug and code adjustment has been done on 08-Sep-2011. 
 *    Small sanitization for main.cpp. All mbed related codes are moved in to "hardware_abs.*". 13-Oct-2011
 */

/** PCA9629 related definitions
 *  
 *  This header file was intended to define the PCA9629 registers but those details are not required in this application. 
 *  So this file only have I2C addresses definitions
 */

#ifndef __PCA9629_REG__
#define __PCA9629_REG__

/** @var PCA9629 I2C bus addresses
 */

typedef enum {
    MOT_ADDR0   = 0x40,
    MOT_ADDR1   = 0x42,
    MOT_ADDR2   = 0x44,
    MOT_ADDR3   = 0x46,
    MOT_ADDR4   = 0x48,
    MOT_ADDR5   = 0x4A,
    MOT_ADDR6   = 0x4C,
    MOT_ADDR7   = 0x4E,
    MOT_ADDR8   = 0x50,
    MOT_ADDR9   = 0x52
}
pca9629_addr;


#endif  //  __PCA9629_REG__
