/** A demo code for PCU9669, PCU9955 and PCA9629
 *
 *  @author  Tedd OKANO, NXP Semiconductors
 *  @version 1.0
 *  @date    26-Oct-2012
 *
 *  Released under the MIT License: http://mbed.org/license/mit
 *
 *    An operation sample of PCU9669 I2C bus controller.
 *  The mbed accesses the PCU9669's parallel port (8 bit address and 8 bit data) using bit-banging.
 *  The bit-banging is poerformed by PortInOut function of mbed library.
 *
 *    DEMO CODE version 
 *       v0.5 written on 13-Oct-2011
 *       v1.0 poerted to PCU9669 sample code API
 *
 *  Simple code sample for PCU9669 is available on 
 *      http://mbed.org/users/nxp_ip/code/mini_board_PCU9669/
 */


#include "transfer_manager.h"
#include "PCU9669_access.h"
#include "hardware_abs.h"
#include "PCx9955_reg.h"
#include "PCA9629_reg.h"
#include "demo_patterns.h"

#include "mbed.h"

#define     TICKER_INTERVAL         0.008

#define     RESET_PULSE_WIDTH_US    10  //  Minimum pulse width is 4us for PCU9669
#define     RESET_RECOVERY_US       1000

Ticker  op;


void operation( void );
void led_action( int count );
void motor_action( int count );
void interrupt_handler( void );
void init_slave_devices( void );
void single_byte_write_into_a_PCA9629( char ch, char i2c_addr, char reg_addr, char val );
void set_one_turn_on_each_end( void );

int main() {
    printf( "\r\nPCU9669 simple demo program on mbed (16 device check)\r\n  build : %s (UTC), %s \r\n\r\n", __TIME__, __DATE__ );

    hardware_initialize();          //  initializing bit-banging parallel port
    reset( RESET_PULSE_WIDTH_US, RESET_RECOVERY_US );  //  assert hardware /RESET sgnal

    if ( start_bus_controller( PCU9669_ID ) )   //  wait the bus controller ready and check chip ID
        return 1;

    write_ch_register( CH_FM_PLUS, INTMSK, 0x30 );  //  set bus controller to ignore NAK return from Fm+ slaves
    install_ISR( &interrupt_handler );              //  interrupt service routine install

    init_slave_devices();           //  set all slaves' all registers and configure buffer for the operation

    op.attach( &operation, TICKER_INTERVAL );

    while ( 1 ) {
    }
}

void operation( void ) {
    pattern_update( gCount );

    motor_action( gCount );      //  motor operation
    led_action( gCount );        //  LED operation

    gCount++;
}


void led_action( int count ) {
    buffer_overwrite( CH_UFM1, 0, 1, gLEDs + N_LED_PER_BOARD * 0, N_LED_PER_BOARD );
    buffer_overwrite( CH_UFM1, 1, 1, gLEDs + N_LED_PER_BOARD * 1, N_LED_PER_BOARD );
    buffer_overwrite( CH_UFM1, 2, 1, gLEDs + N_LED_PER_BOARD * 2, N_LED_PER_BOARD );
    buffer_overwrite( CH_UFM1, 3, 1, gLEDs + N_LED_PER_BOARD * 3, N_LED_PER_BOARD );
    buffer_overwrite( CH_UFM2, 0, 1, gLEDs + N_LED_PER_BOARD * 4, N_LED_PER_BOARD );
    buffer_overwrite( CH_UFM2, 1, 1, gLEDs + N_LED_PER_BOARD * 5, N_LED_PER_BOARD );
    buffer_overwrite( CH_UFM2, 2, 1, gLEDs + N_LED_PER_BOARD * 6, N_LED_PER_BOARD );
    buffer_overwrite( CH_UFM2, 3, 1, gLEDs + N_LED_PER_BOARD * 7, N_LED_PER_BOARD );

    start( CH_UFM1 );
    start( CH_UFM2 );
}


void motor_action( int count ) {
#if 0
    static char     mot_cntl_order[ 5 ]    = {
        MOT_ADDR5, MOT_ADDR6, MOT_ADDR7, MOT_ADDR8, MOT_ADDR9
    };
    static char     motor_count     = 0;

    if ( !(count & 0x1F) ) {
        single_byte_write_into_a_PCA9629( CH_FM_PLUS, mot_cntl_order[ motor_count % 5 ], 0x26, 0x80 | ((motor_count / 5) & 0x1) );
        motor_count++;
    }
#endif

}

void interrupt_handler( void ) {
    char    global_status;
    char    channel_status;

    global_status  = read_data( CTRLSTATUS );

    if ( global_status & 0x01 ) {  //  ch0
        channel_status  = read_ch_register( 0, CHSTATUS );
    }
    if ( global_status & 0x02 ) {
        channel_status  = read_ch_register( 1, CHSTATUS );
    }
    if ( global_status & 0x04 ) {
        channel_status  = read_ch_register( 2, CHSTATUS );
    }
//    printf( "ISR channel_status 0x%02X\r\n", channel_status );
}
