/** A sample code for "mini board PCU9669/PCA9665"
 *
 *  @author  Akifumi (Tedd) OKANO, NXP Semiconductors
 *  @version 1.0
 *  @date    26-Mar-2012
 *
 *  Released under the MIT License: http://mbed.org/license/mit
 *
 *  An operation sample of PCU9669/PCA9665 I2C bus controller.
 *  The mbed accesses the bus controller's parallel port (8/2 bit address and 8 bit data) by bit-banging.
 *  The bit-banging is poerformed by PortInOut function of mbed library.
 *
 *    To make the code porting easier, all codes are partitioned into layers to abstract other parts.
 *    The mbed specific parts are concentrated in lowest layer: "hardware_abs.*".
 *    This module may need to be modified for the porting.
 *
 *    All other upper layers are writen in standard-C.
 *
 *    base code is written from 05-Sep-2011 to 09-Sep-2011.
 *    And demo code has been build on 11-Sep-2011.
 *    Debug and code adjustment has been done on 08-Sep-2011.
 *    Small sanitization for main.cpp. All mbed related codes are moved in to "hardware_abs.*". 13-Oct-2011
 *    hardware_abs are moved into parallel_bus library folder, 3 LED driver operation sample 13-Feb.-2012
 *    PCU9669 and PCA9665 codes are packed in a project 14-Feb-2012.
 *
 *    Before builidng the code, please edit the file mini_board_PCU9669/config.h
 *    Un-comment the target name what you want to target.
 */


#include "config.h"
#include "hardware_abs.h"
#include "PCA9665_access.h"
#include "PCx9955_reg.h"
#include "PCA9629_reg.h"
#include "utility.h"

#include "mbed.h"           //  this header is required only when printf() is used. 

#ifdef CODE_FOR_PCA9665

#define RESET_PULSE_WIDTH_US    100
#define RESET_RECOVERY_US       100

char    PCx9955_reg_data[] = {
    0x80,                                       //  Strat register address with AutoIncrement bit
    0x00, 0x05,                                 //  MODE1, MODE2
    0xAA, 0xAA, 0xAA, 0xAA,                     //  LEDOUT[3:0]
    0x80, 0x00,                                 //  GRPPWM, GRPFREQ
    PWM_INIT,  PWM_INIT,  PWM_INIT,  PWM_INIT,  //  PWM[3:0]
    PWM_INIT,  PWM_INIT,  PWM_INIT,  PWM_INIT,  //  PWM[7:4]
    PWM_INIT,  PWM_INIT,  PWM_INIT,  PWM_INIT,  //  PWM[11:8]
    PWM_INIT,  PWM_INIT,  PWM_INIT,  PWM_INIT,  //  PWM[15:12]
    IREF_INIT, IREF_INIT, IREF_INIT, IREF_INIT, //  IREF[3:0]
    IREF_INIT, IREF_INIT, IREF_INIT, IREF_INIT, //  IREF[7:4]
    IREF_INIT, IREF_INIT, IREF_INIT, IREF_INIT, //  IREF[11:8]
    IREF_INIT, IREF_INIT, IREF_INIT, IREF_INIT, //  IREF[15:12]
    0x08                                        //  OFFSET: 1uS offsets
};

char    PCx9955_reg_read_start_address  = 0x80;

char    read_buffer[ 41 ];


int main() {
    int     count   = 0;
    int     i;
    int     j;

    printf( "\r\nPCU9665 simple demo program on mbed\r\n  build : %s (UTC), %s \r\n\r\n", __TIME__, __DATE__ );

    hardware_initialize();          //  initializing bit-banging parallel port
    reset( RESET_PULSE_WIDTH_US, RESET_RECOVERY_US );
    PCA9665_init();

//  set_speed_mode( SPEED_STD_MODE );
//  set_speed_mode( SPEED_FAST_MODE );
    set_speed_mode( SPEED_FAST_MODE_PLUS );

//  set_buffer_mode( DISABLE );
    set_buffer_mode( ENABLE );

    while ( 1 ) {
        for ( i = 0; i < 16; i++ ) {
            for ( j = 0; j < 256; j += 4 ) {

                PCx9955_reg_data[ 9 + i ]   = j;

                if ( i & 0x01 )
                    set_buffer_mode( ENABLE );
                else
                    set_buffer_mode( DISABLE );

                i2c_write( PCx9955_ADDR0, PCx9955_reg_data, sizeof( PCx9955_reg_data ), NEXT_RESTART );
                i2c_write( PCx9955_ADDR0, &PCx9955_reg_read_start_address, sizeof( PCx9955_reg_read_start_address ), NEXT_RESTART );
                i2c_read( PCx9955_ADDR0, read_buffer, sizeof( read_buffer ), STOP );

//                dump_read_data( read_buffer, sizeof( read_buffer ) );

                wait( 0.01 );
                count++;
            }
        }
        for ( i = 0; i < 16; i++ )
            PCx9955_reg_data[ 9 + i ]   = 0;
    }
}

#endif  //  CODE_FOR_PCA9665
