/*
 *  A sample code for PCF2127 library
 *
 *  @author     Akifumi (Tedd) OKANO, NXP Semiconductors
 *  @version    1.5
 *  @date       04-Dec-2014
 *
 *  PCF2127 is a "real time clock (RTC)" module which is including a Xtal and TCXO
 *  http://www.nxp.com/products/interface_and_connectivity/real_time_clocks/rtcs_with_temp_compensation/series/PCF2127.html
 *
 *  RTC initializing part is ported from..
 *    http://mbed.org/users/roen/notebook/real-time/
 *
 *  This code is refined version of..
 *    http://developer.mbed.org/users/okano/code/NXP_PCF2127A/
 */

#include "mbed.h"
#include "C12832.h"
#include "PCF2127.h"

C12832          lcd( p5, p7, p6, p8, p11 );
PCF2127         rtc( p28, p27 );

void    show_time( void );
void    set_time( void );

int main()
{
    printf( "PCF2127 demo started.\r\n" );

    if ( rtc.is_init_required() ) {
        lcd.locate( 0, 0 );
        lcd.printf( "please set time on terminal" );

        set_time();

        lcd.cls();
    }

    lcd.locate( 0,20 );
    lcd.printf( "PCF2127 demo" );

    while ( 1 ) {
        show_time();
        wait( 0.1 );
    }
}

void show_time( void )
{
    struct tm   dt, *dtp;
    time_t      t;
    char        s[ 30 ];
    dtp = &dt;

    rtc.clear_intr();

    //  get time information from PCF2127
    t       = rtc.time( NULL );
    dtp     = localtime( &t );

    //  print time and date on terminal
    strftime( s, 30, "%H:%M:%S, %Y/%b/%d %a", dtp );
    printf( "%s\r\n", s );

    //  print time on LCD screen
    strftime( s, 20, "%H:%M:%S PCF2127", dtp );
    lcd.locate( 0, 0 );
    lcd.printf( "%s", s );

    //  print date on LCD screen
    strftime( s, 20, "%Y/%b/%d(%a)", dtp );
    lcd.locate( 0, 10 );
    lcd.printf( "%s", s );
}

void set_time( void )
{
#define MAX_CHAR_LENGTH 21
    char    s[ MAX_CHAR_LENGTH ];

    printf( "Enter current date and time:\r\n" );
    printf( "YYYY MM DD HH MM SS[enter]\r\n" );

    fgets( s, MAX_CHAR_LENGTH, stdin );
    printf( "user input: \"%s\"\r\n", s );

    rtc.set_time( s );
}

