#include    "GpioBusInOut.h"

GpioBusInOut::GpioBusInOut(
    CompGpioExp &gpiop,
    GpioPinName p0,  GpioPinName p1,  GpioPinName p2,  GpioPinName p3,
    GpioPinName p4,  GpioPinName p5,  GpioPinName p6,  GpioPinName p7,
    GpioPinName p8,  GpioPinName p9,  GpioPinName p10, GpioPinName p11,
    GpioPinName p12, GpioPinName p13, GpioPinName p14, GpioPinName p15  )
    : gpio_p( &gpiop )
{
    GpioPinName pins[16] = { p0, p1, p2, p3, p4, p5, p6, p7, p8, p9, p10, p11, p12, p13, p14, p15 };
    init( gpiop, pins );
}

GpioBusInOut::GpioBusInOut( CompGpioExp &gpiop, GpioPinName pins[16] )
{
    init( gpiop, pins );
}

void GpioBusInOut::init( CompGpioExp &gpiop, GpioPinName pins[16] )
{
    for ( int i = 0; i < 16; i++ )
        pin_list[ i ]   = pins[ i ];

    mask_bits    = ~(make_bitpattern( 0xFFFF ));
}

GpioBusInOut::~GpioBusInOut()
{
}

void GpioBusInOut::write( int value )
{
    int bitpattern;

    bitpattern  = make_bitpattern( value );
    gpio_p->write_with_mask( bitpattern, mask_bits );
}

int GpioBusInOut::make_bitpattern( int value )
{
    int bit_pattern = 0;

    for ( int i = 0; i < 16; i++ )
        bit_pattern     |= (pin_list[ i ] != X_NC) ? ((value >> i) & 0x1) << pin_list[ i ] : 0x0;

    return ( bit_pattern );
}

int GpioBusInOut::read( void )
{
    int r;
    int v   = 0;

    r   = gpio_p->read();

    for ( int i = 0; i < 16; i++ )
        v   |= (pin_list[ i ] != X_NC) ? ((r >> pin_list[ i ]) & 0x1) << i : 0x0;
    
    return v;
}

void GpioBusInOut::output( void )
{
    gpio_p->configure_with_mask( 0x0, mask_bits );
}

void GpioBusInOut::input( void )
{
    gpio_p->configure_with_mask( ~0x0, mask_bits );
}

GpioBusInOut& GpioBusInOut::operator=( int rhs )
{
    write( rhs );
    return *this;
}

GpioBusInOut& GpioBusInOut::operator=( GpioBusInOut& rhs )
{
    write(rhs.read());
    return *this;
}


GpioBusInOut::operator int( void )
{
    return( read() );
}
