#include    "mbed.h"
#include    "PCAL9554.h"


PCAL9554::PCAL9554( PinName i2c_sda, PinName i2c_scl, char i2c_address )
    : PCAL955x( i2c_sda, i2c_scl, i2c_address ), n_of_pins( 8 )
{
}

PCAL9554::PCAL9554( I2C &i2c_obj, char i2c_address )
    : PCAL955x( i2c_obj, i2c_address ), n_of_pins( 8 )
{
}

PCAL9554::~PCAL9554()
{
}

int PCAL9554::number_of_pins( void )
{
    return ( n_of_pins );
}

void PCAL9554::reg_index_write( char reg_index, int data )
{
    char    a[ 2 ];

    a[ 0 ]  = regmap[ reg_index ];
    a[ 1 ]  = data;
    
    bus_write( a, sizeof( a ) );
}

int PCAL9554::reg_index_read( char reg_index )
{
    char    a;

    bus_read( regmap[ reg_index ], &a, sizeof( a ) );

    return ( a );
}

PCAL9554& PCAL9554::operator= ( int bit_pattern )
{
    write( bit_pattern );
    return ( *this );
}

PCAL9554& PCAL9554::operator= ( PCAL9554& rhs )
{
    write( rhs.read() );
    return *this;
}

const char PCAL9554::regmap[]   = {
    InputPort,
    OutoutPort,
    PolarityInversionPort,
    ConfigurationPort,
    OutputDriveStrength0,
    OutputDriveStrength1,
    InputLatch,
    PullUpPullDowmEnable,
    PullUpPullDowmSelection,
    InterruptMask,
    InterruptStatus,
    OutputPortConfiguration
};
