/** GpioBusIn API for GPIO-expander component class 
 *
 *  @author  Akifumi (Tedd) OKANO, NXP Semiconductors
 *  @version 0.6
 *  @date    19-Mar-2015
 *
 *  Released under the Apache 2 license
 */

#ifndef     MBED_GpioBusIn
#define     MBED_GpioBusIn

#include    "mbed.h"
#include    "GpioBusInOut.h"

/** GpioBusIn class
 *
 *  @class GpioBusIn
 *
 *  "GpioBusIn" class works like "BusIn" class of mbed-SDK. 
 *  This class provides pin oriented API, abstracting the GPIO-expander chip. 
 *
 *  Example:
 *  @code
 *  #include "mbed.h"
 *  #include "PCAL9555.h"
 *  
 *  PCAL9555    gpio_exp( p28, p27, 0xE8 );    //  SDA, SCL, Slave_address(option)
 *  GpioBusIn   nibble( gpio_exp, X0_0, X0_1, X0_2, X0_3 );
 *   
 *  int main() {
 *      while ( 1 ) {
 *          switch ( nibble ) {
 *              case 0x3: printf( "Hello!\n" ); break; // X0_0 and X0_1 are 1
 *              case 0x8: printf( "World!\n" ); break; // X0_3 is 1
 *          }
 *      }
 *  }
 *  @endcode
 */
class GpioBusIn : public GpioBusInOut
{
public:

#if DOXYGEN_ONLY
    /** GPIO-Expander pin names */
    typedef enum {
    X0_0,           /**< P0_0 pin                                   */
    X0_1,           /**< P0_1 pin                                   */
    X0_2,           /**< P0_2 pin                                   */
    X0_3,           /**< P0_3 pin                                   */
    X0_4,           /**< P0_4 pin                                   */
    X0_5,           /**< P0_5 pin                                   */
    X0_6,           /**< P0_6 pin                                   */
    X0_7,           /**< P0_7 pin                                   */
    X1_0,           /**< P1_0 pin (for 16-bit GPIO device only)     */
    X1_1,           /**< P1_1 pin (for 16-bit GPIO device only)     */
    X1_2,           /**< P1_2 pin (for 16-bit GPIO device only)     */
    X1_3,           /**< P1_3 pin (for 16-bit GPIO device only)     */
    X1_4,           /**< P1_4 pin (for 16-bit GPIO device only)     */
    X1_5,           /**< P1_5 pin (for 16-bit GPIO device only)     */
    X1_6,           /**< P1_6 pin (for 16-bit GPIO device only)     */
    X1_7,           /**< P1_7 pin (for 16-bit GPIO device only)     */
    X0  = X0_0,     /**< P0_0 pin                                   */
    X1  = X0_1,     /**< P0_1 pin                                   */
    X2  = X0_2,     /**< P0_2 pin                                   */
    X3  = X0_3,     /**< P0_3 pin                                   */
    X4  = X0_4,     /**< P0_4 pin                                   */
    X5  = X0_5,     /**< P0_5 pin                                   */
    X6  = X0_6,     /**< P0_6 pin                                   */
    X7  = X0_7,     /**< P0_7 pin                                   */
    X8  = X1_0,     /**< P1_0 pin (for 16-bit GPIO device only)     */
    X9  = X1_1,     /**< P1_1 pin (for 16-bit GPIO device only)     */
    X10 = X1_2,     /**< P1_2 pin (for 16-bit GPIO device only)     */
    X11 = X1_3,     /**< P1_3 pin (for 16-bit GPIO device only)     */
    X12 = X1_4,     /**< P1_4 pin (for 16-bit GPIO device only)     */
    X13 = X1_5,     /**< P1_5 pin (for 16-bit GPIO device only)     */
    X14 = X1_6,     /**< P1_6 pin (for 16-bit GPIO device only)     */
    X15 = X1_7,     /**< P1_7 pin (for 16-bit GPIO device only)     */
    
    X_NC = ~0x0L    /**< for when the pin is left no-connection     */
    } GpioPinName;
#endif

    /** Create an GpioBusIn, connected to the specified pins
     *
     *  @param gpiop    Instance of GPIO expander device
     *  @param p<n>     DigitalInOut pin to connect to bus bit p<n> (GpioPinName)
     *
     *  @note
     *    It is only required to specify as many pin variables as is required
     *    for the bus; the rest will default to NC (not connected)
     */
    GpioBusIn( CompGpioExp &gpiop,
               GpioPinName p0,         GpioPinName p1  = X_NC, GpioPinName p2  = X_NC, GpioPinName p3  = X_NC,
               GpioPinName p4  = X_NC, GpioPinName p5  = X_NC, GpioPinName p6  = X_NC, GpioPinName p7  = X_NC,
               GpioPinName p8  = X_NC, GpioPinName p9  = X_NC, GpioPinName p10 = X_NC, GpioPinName p11 = X_NC,
               GpioPinName p12 = X_NC, GpioPinName p13 = X_NC, GpioPinName p14 = X_NC, GpioPinName p15 = X_NC );
    GpioBusIn( CompGpioExp &gpiop, GpioPinName pins[ 16 ] );

    /**
     *  Destractor
     */
    virtual     ~GpioBusIn();

    /** A shorthand for read()
     */
    operator int( void );

private:
    GpioBusIn& operator= ( int rhs );
    GpioBusIn& operator= ( GpioBusIn& rhs );
}
;

#endif  //  MBED_GpioBusIn
