/** GpioDigitalInOut API for GPIO-expander component class 
 *
 *  @author  Akifumi (Tedd) OKANO, NXP Semiconductors
 *  @version 0.6
 *  @date    19-Mar-2015
 *
 *  Released under the Apache 2 license
 */

#ifndef     MBED_GpioDigitalOut
#define     MBED_GpioDigitalOut

#include    "mbed.h"
#include    "GpioDigitalInOut.h"

/** GpioDigitalOut class
 *
 *  @class GpioDigitalOut
 *
 *  "GpioDigitalOut" class works like "DigitalOut" class of mbed-SDK. 
 *  This class provides pin oriented API, abstracting the GPIO-expander chip. 
 *
 *  Example:
 *  @code
 *  #include "mbed.h"
 *  #include "PCAL9555.h"
 *  
 *  PCAL9555        gpio_exp( p28, p27, 0xE8 );    //  SDA, SCL, Slave_address(option)
 *  GpioDigitalOut  pin( gpio_exp, X0_0 );
 *   
 *  int main() {
 *      while( 1 ) {
 *          pin = 1;
 *          wait( 0.2 );
 *          pin = 0;
 *          wait( 0.2 );
 *      }
 *  }
 *  @endcode
 */
 class GpioDigitalOut : public GpioDigitalInOut
{
public:

#if DOXYGEN_ONLY
    /** GPIO-Expander pin names */
    typedef enum {
    X0_0,           /**< P0_0 pin                                   */
    X0_1,           /**< P0_1 pin                                   */
    X0_2,           /**< P0_2 pin                                   */
    X0_3,           /**< P0_3 pin                                   */
    X0_4,           /**< P0_4 pin                                   */
    X0_5,           /**< P0_5 pin                                   */
    X0_6,           /**< P0_6 pin                                   */
    X0_7,           /**< P0_7 pin                                   */
    X1_0,           /**< P1_0 pin (for 16-bit GPIO device only)     */
    X1_1,           /**< P1_1 pin (for 16-bit GPIO device only)     */
    X1_2,           /**< P1_2 pin (for 16-bit GPIO device only)     */
    X1_3,           /**< P1_3 pin (for 16-bit GPIO device only)     */
    X1_4,           /**< P1_4 pin (for 16-bit GPIO device only)     */
    X1_5,           /**< P1_5 pin (for 16-bit GPIO device only)     */
    X1_6,           /**< P1_6 pin (for 16-bit GPIO device only)     */
    X1_7,           /**< P1_7 pin (for 16-bit GPIO device only)     */
    X0  = X0_0,     /**< P0_0 pin                                   */
    X1  = X0_1,     /**< P0_1 pin                                   */
    X2  = X0_2,     /**< P0_2 pin                                   */
    X3  = X0_3,     /**< P0_3 pin                                   */
    X4  = X0_4,     /**< P0_4 pin                                   */
    X5  = X0_5,     /**< P0_5 pin                                   */
    X6  = X0_6,     /**< P0_6 pin                                   */
    X7  = X0_7,     /**< P0_7 pin                                   */
    X8  = X1_0,     /**< P1_0 pin (for 16-bit GPIO device only)     */
    X9  = X1_1,     /**< P1_1 pin (for 16-bit GPIO device only)     */
    X10 = X1_2,     /**< P1_2 pin (for 16-bit GPIO device only)     */
    X11 = X1_3,     /**< P1_3 pin (for 16-bit GPIO device only)     */
    X12 = X1_4,     /**< P1_4 pin (for 16-bit GPIO device only)     */
    X13 = X1_5,     /**< P1_5 pin (for 16-bit GPIO device only)     */
    X14 = X1_6,     /**< P1_6 pin (for 16-bit GPIO device only)     */
    X15 = X1_7,     /**< P1_7 pin (for 16-bit GPIO device only)     */
    
    X_NC = ~0x0L    /**< for when the pin is left no-connection     */
    } GpioPinName;
#endif

    /** Create a GpioDigitalOut connected to the specified pin
     *
     *  @param gpiop    Instance of GPIO expander device
     *  @param pin_name DigitalInOut pin to connect to
     */
    GpioDigitalOut( CompGpioExp &gpiop, GpioPinName pin_name );

    /**
     *  Destractor
     */
    virtual ~GpioDigitalOut();

    /** A shorthand for write()
     */
    GpioDigitalOut&     operator= ( int rhs );
    GpioDigitalOut&     operator= ( GpioDigitalOut& rhs );
}
;

#endif  //  MBED_GpioDigitalOut
