/*
 *  very simple sample code for PCA9955 LPD driver
 *
 *      10-Oct-2012
 *      NXP Semiconductors - Interface Products
 */

#include "mbed.h"

#define     PCA9956A_ADDRESS    0x02
#define     IREF_INIT           0x10

I2C     i2c( p28, p27 );

char    init_array[] = {
    0x80,                                           //  Command
    0x00, 0x05,                                     //  MODE1, MODE2
    0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA,             //  LEDOUT[3:0]
    0x80, 0x00,                                     //  GRPPWM, GRPFREQ
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //  PWM[7:0]
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //  PWM[15:8]
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //  PWM[23:16]
    IREF_INIT, IREF_INIT, IREF_INIT, IREF_INIT, IREF_INIT, IREF_INIT, IREF_INIT, IREF_INIT, //  IREF[7:0]
    IREF_INIT, IREF_INIT, IREF_INIT, IREF_INIT, IREF_INIT, IREF_INIT, IREF_INIT, IREF_INIT, //  IREF[15:8]
    IREF_INIT, IREF_INIT, IREF_INIT, IREF_INIT, IREF_INIT, IREF_INIT, IREF_INIT, IREF_INIT, //  IREF[23:16]
    0x08                                            //  OFFSET: 1uS offsets
};


int main()
{
    char    data[ 2 ];
    int     i   = 0;

    i2c.write( PCA9956A_ADDRESS, init_array, sizeof( init_array ) );

    while ( 1 ) {
        if ( !(i % (256 * 24)) ) {
            data[ 0 ]   = 0x3F;
            data[ 1 ]   = 0x00;
            i2c.write( PCA9956A_ADDRESS, data, 2 );

        } else {
            data[ 0 ]   = 0x0A + ((i >> 8) % 24);
            data[ 1 ]   = i & 0xFF;
            i2c.write( PCA9956A_ADDRESS, data, 2 );
        }
        wait_ms( 1 );
        i++;
    }
}

