#include "mbed.h"
#include "PCA9956A.h"

PCA9956A    led_cntlr( p28, p27, 0x02 );    //  SDA, SCL, Slave_address(option)
LedPwmOutCC led0( led_cntlr, L0  );         //  Instance for LED0 pin
LedPwmOutCC led1( led_cntlr, L1  );         //  Instance for LED1 pin
LedPwmOutCC led2( led_cntlr, L2  );         //  Instance for LED2 pin

int main()
{
    led0.current( 0.5 );    //  LED0 pin current output setting to 50%
    led1.current( 0.5 );    //  LED1 pin current output setting to 50%
    led2.current( 0.5 );    //  LED2 pin current output setting to 50%

    while(1) {
        
        for ( float p = 1.0; p >= 0.0; p -= 0.01 ) {
            led0    = p;    //  Set LED0 output PWM dutycycle as 'p'
            wait( 0.01 );
        }
        
        for ( float p = 1.0; p >= 0.0; p -= 0.01 ) {
            led1    = p;    //  Set LED1 output PWM dutycycle as 'p'
            wait( 0.01 );
        }
        
        for ( float p = 1.0; p >= 0.0; p -= 0.01 ) {
            led2    = p;    //  Set LED2 output PWM dutycycle as 'p'
            wait( 0.01 );
        }
    }
}
