/*
 *  very simple sample code for PCA9955 LPD driver
 *
 *      10-Oct-2012
 *      NXP Semiconductors - Interface Products
 */

#include "mbed.h"

#define     PCA9955_ADDRESS     0xC0

I2C     i2c( p28, p27 );

char    init_array[] = {
    0x80,                                           //  Command
    0x00, 0x05,                                     //  MODE1, MODE2
    0xAA, 0xAA, 0xAA, 0xAA,                         //  LEDOUT[3:0]
    0x80, 0x00,                                     //  GRPPWM, GRPFREQ
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //  PWM[7:0]
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, //  PWM[15:8]
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, //  IREF[7:0]
    0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, 0x10, //  IREF[15:8]
    0x08                                            //  OFFSET: 1uS offsets
};


int main()
{
    char    data[ 2 ];
    int     i   = 0;

    i2c.write( PCA9955_ADDRESS, init_array, sizeof( init_array ) );

    while ( 1 ) {
        if ( !(i & 0xFFF) ) {
            data[ 0 ]   = 0x42;
            data[ 1 ]   = 0x00;
            i2c.write( PCA9955_ADDRESS, data, 2 );

        } else {
            data[ 0 ]   = 0x0A + ((i >> 8) & 0xF);
            data[ 1 ]   = i & 0xFF;
            i2c.write( PCA9955_ADDRESS, data, 2 );

        }
        wait_ms( 1 );
        i++;
    }
}

