/*
 *  PCA9955 (I2C 16 channel LED driver) demo application
 *
 *  Released under the MIT License: http://mbed.org/license/mit
 *
 *  revision 1.0  15-June-2011 / 10-Aug-2012
 */

#include    "mbed.h"
#include    "PCA9955.h"

#define     MAX_IREF    0x20

#define     PI          3.14159265
#define     LOOP        100
#define     CYCLE       1.0

PCA9955     led_driver( p28, p27, 0xC0 );   // SDA, SCL, I2C_slave_sddress

DigitalOut  syncpin( p21 );

void demo_0( void );
void demo_1( void );
void demo_2( void );
void demo_FF( void );

I2C i2c( p28, p27 );

main() {

    while ( 1 ) {
        demo_2();
        demo_0();
        demo_1();
        //demo_FF();
    }
}

void demo_0( void ) {
    int     i;

    srand( 0xFF00 );

    led_driver  = 0x0000;
    led_driver.set_all_intensity( 0xFF );           //  PWM
    led_driver.set_all_intensity( MAX_IREF, true ); //  IREF

    for ( i = 0; i < 128; i++ ) {
        led_driver  = 0x0001 << (rand() % 16);
        wait( 0.05 );
    }
}

void demo_1( void ) {
    char    v[ 16 ] = { 0xFF };
    int     sel;
    int     i;

    srand( 0xFF00 );

    led_driver  = 0xFFFF;
    led_driver.set_all_intensity( v );              //  PWM
    led_driver.set_all_intensity( MAX_IREF, true ); //  IREF

    for ( i = 0; i < 256; i++ ) {
        for ( sel = 0; sel < 16; sel++ ) {
            v[ sel ]  = (char)((float)(v[ sel ]) * 0.8);
        }

        v[ rand() % 16 ]  = 0xFF;

        led_driver.set_all_intensity( v );              //  PWM
        wait( 0.05 );
    }
}

void demo_2( void ) {
    int     demo_loop;
    char    intensity[ 3 ];
    char    pwms[ 16 ];
    int     color;
    int     sel;
    int     i;

    led_driver  = 0xFFFF;
    led_driver.set_all_intensity( (char)0x00 );           //  PWM
    led_driver.set_all_intensity( MAX_IREF, true );     //  IREF

    for ( demo_loop = 0; demo_loop < 10; demo_loop++ ) {
        for ( i = 0; i < 100; i++ ) {
            for ( color = 0; color < 3; color++ ) {
                intensity[ color ]   = (char)(pow(sin( (((float)i  * PI) / (float)LOOP)  + (color * (PI / 3.0))), 4) * 0xFF);
            }
            for ( sel = 0; sel < 16; sel++ ) {
                pwms[ sel ] = intensity[ sel % 3 ];
                led_driver.set_all_intensity( pwms );
            }
            wait( (float)CYCLE / (float)LOOP );
        }
    }
}

void demo_FF( void ) {
    unsigned short  flags;
    unsigned int    i;

    syncpin = 1;

    led_driver  = 0xFFFF;
    led_driver.set_all_intensity( 0x7F );           //  PWM

    printf( "\r\n\r\nFAULTTEST\r\n" );

    while ( 1 ) {
        for ( i = 0; i < 256; i++ ) {
            led_driver.set_all_intensity( (char)i, true ); //  IREF
            syncpin = 0;
            flags   = led_driver.fault_test();
            syncpin = 1;

//            printf( "IREF=0x%02X : flags = 0x%04X\r\n", i, flags );
            printf( "IREF=0x%02X : flags = 0x%04X\r", i, flags );
            //wait_ms( 100 );
        }
    }
}

#if 0
main() {
    char    v[ 16 ] = { 0xFF };
    int     sel;

    srand( 0 );

    led_driver  = 0xFFFF;
    led_driver.set_all_intensity( v );              //  PWM
    led_driver.set_all_intensity( MAX_IREF, true ); //  IREF

    while ( 1 ) {
        for ( sel = 0; sel < 16; sel++ ) {
            v[ sel ]  = (char)((float)(v[ sel ]) * 0.8);
        }

        v[ rand() % 16 ]  = 0xFF;

        led_driver.set_all_intensity( v );              //  PWM
        wait( 0.05 );
    }
}
#endif
