#include "mbed.h"
#include "PCA9955A.h"

//  making an instance of PCA9955A (PCA9955A is cpmpatible to PCA9955B)
PCA9955A    led_cntlr( p28, p27, 0x02 );    //  SDA, SCL, Slave_address(option)

//  LED output instances in array
LedPwmOutCC leds[]  = {
    LedPwmOutCC ( led_cntlr,  L0  ),         //  Instance for LED0  pin
    LedPwmOutCC ( led_cntlr,  L1  ),         //  Instance for LED1  pin
    LedPwmOutCC ( led_cntlr,  L2  ),         //  Instance for LED2  pin
    LedPwmOutCC ( led_cntlr,  L3  ),         //  Instance for LED3  pin
    LedPwmOutCC ( led_cntlr,  L4  ),         //  Instance for LED4  pin
    LedPwmOutCC ( led_cntlr,  L5  ),         //  Instance for LED5  pin
    LedPwmOutCC ( led_cntlr,  L6  ),         //  Instance for LED6  pin
    LedPwmOutCC ( led_cntlr,  L7  ),         //  Instance for LED7  pin
    LedPwmOutCC ( led_cntlr,  L8  ),         //  Instance for LED8  pin
    LedPwmOutCC ( led_cntlr,  L9  ),         //  Instance for LED9  pin
    LedPwmOutCC ( led_cntlr, L10  ),         //  Instance for LED10 pin
    LedPwmOutCC ( led_cntlr, L11  ),         //  Instance for LED11 pin
    LedPwmOutCC ( led_cntlr, L12  ),         //  Instance for LED12 pin
    LedPwmOutCC ( led_cntlr, L13  ),         //  Instance for LED13 pin
    LedPwmOutCC ( led_cntlr, L14  ),         //  Instance for LED14 pin
    LedPwmOutCC ( led_cntlr, L15  )          //  Instance for LED15 pin
};

int main()
{
    for ( int i = 0; i < 16; i++ )
        leds[ i ].current( 0.5 );    //  LED output current set to 50%

    while(1) {
        for ( int i = 0; i < 16; i++ ) {
            for ( float p = 1.0; p >= 0.0; p -= 0.01 ) {
                leds[ i ]    = p;   //  set 'p' value into LED output instance
                wait( 0.01 );
            }
        }
    }
}
