/** A sample code for "mini board PCU9669/PCA9665"
 *
 *  @author  Akifumi (Tedd) OKANO, NXP Semiconductors
 *  @version 1.2
 *  @date    13-Jan-2015
 *
 *  Released under the MIT License: http://mbed.org/license/mit
 *
 *  An operation sample of PCU9669/PCA9665 I2C bus controller.
 *  The mbed accesses the bus controller's parallel port (8/2 bit address and 8 bit data) by bit-banging.
 *  The bit-banging is poerformed by PortInOut function of mbed library.
 *
 *    To make the code porting easier, all codes are partitioned into layers to abstract other parts.
 *    The mbed specific parts are concentrated in lowest layer: "hardware_abs.*".
 *    This module may need to be modified for the porting.
 *
 *    All other upper layers are writen in standard-C.
 *
 *    base code is written from 05-Sep-2011 to 09-Sep-2011.
 *    And demo code has been build on 11-Sep-2011.
 *    Debug and code adjustment has been done on 08-Sep-2011.
 *    Small sanitization for main.cpp. All mbed related codes are moved in to "hardware_abs.*". 13-Oct-2011
 *    hardware_abs are moved into parallel_bus library folder, 3 LED driver operation sample 13-Feb.-2012
 *    PCU9669 and PCA9665 codes are packed in a project 14-Feb-2012.
 *
 *    Before builidng the code, please edit the file mini_board_PCU9669/config.h
 *    Un-comment the target name what you want to target.
 */

#ifndef MINIBOARD_PCA9665_ACCESS__
#define MINIBOARD_PCA9665_ACCESS__


#define     OP_MODE_BOTH            0
#define     OP_MODE_MASTER_ONLY     1
#define     OP_MODE_SLAVE_ONLY      2

#define     RESTART_DISABLE         0
#define     STOP                    RESTART_DISABLE
#define     RESTART_ENABLE          1
#define     NEXT_RESTART            RESTART_ENABLE

#define     PCA9665_BURST_DATA_ACCESS


typedef enum {
    SPEED_STD_MODE          = 0,
    SPEED_FAST_MODE         = 1,
    SPEED_FAST_MODE_PLUS    = 2
}
speed_mode_val;

typedef enum {
    DISABLE = 0,
    ENABLE  = 1
}
buffer_mode_flag;

void set_speed_mode( int mode );
void set_buffer_mode( int mode );

int i2c_write( char addr, char *dp, char length, char restart_flag );
int i2c_read( char addr, char *dp, char length, char restart_flag );

int i2c_write_buffer_mode( char addr, char *dp, char length, char restart_flag );
int i2c_read_buffer_mode( char addr, char *dp, char length, char restart_flag );

int i2c_write_byte_mode( char addr, char *dp, char length, char restart_flag );
int i2c_read_byte_mode( char addr, char *dp, char length, char restart_flag );

void PCA9665_init( void );

void indirect_write( char idaddr, char data );
char indirect_read( char idaddr );

#endif  //  MINIBOARD_PCA9665_ACCESS__

