/** PCA9632 very simple operation sample
 *
 *  @author  Akifumi (Tedd) OKANO, NXP Semiconductors
 *  @version 1.0
 *  @date    22-Jan-2014
 *
 *  Released under the  Apache 2.0 open source licence -- http://opensource.org/licenses/Apache-2.0
 *
 *  This sample operates 4 LEDs on the evaluation board (OM13269 -- http://www.nxp.com/documents/user_manual/UM10528.pdf). 
 *  LED1(Red), LED2(Green) and LED3(Blue) are PWM controlled from mbed. 
 *  LED4 is controlled by group PWM function of PCA9632
 */

#include "mbed.h"

I2C     i2c( p28, p27 );


char    data[]  = {
    0x80,
    0x80, 0x21,
    0x00, 0x00, 0x00, 0x40,
    0x80, 0x02,
    0xEA
};

char    blink_rate[]    = { 0x07, 0x00 };

#define     I2C_ADDRESS     0xC4

int main()
{
    int     count;

    i2c.write( I2C_ADDRESS, data, sizeof( data ) );

    while ( 1 ) {

        for ( count = 0; count < 12; count++ ) {
            data[ 3 + ((count + 2) % 3) ]    = 0xFF;
            data[ 3 + ((count + 1) % 3) ]    = 0x00;
            data[ 3 + ((count + 0) % 3) ]    = 0x00;
            data[ 7 ]                               = 0;
            data[ 8 ]                               = 0;
            i2c.write( I2C_ADDRESS, data, 9 );
            wait( 0.25 );

            data[ 3 ]    = 0x00;
            data[ 4 ]    = 0x00;
            data[ 5 ]    = 0x00;
            data[ 7 ]                               = 0;
            data[ 8 ]                               = 0;
            i2c.write( I2C_ADDRESS, data, 9 );

            count++;
            wait( 0.25 );
        }

        for ( count = 0; count < 4096; count++ ) {
            data[ 3 + (((count >> 8) + 2) % 3) ]    = 0xFF - (count & 0xFF);
            data[ 3 + (((count >> 8) + 1) % 3) ]    = 0x00;
            data[ 3 + (((count >> 8) + 0) % 3) ]    = count & 0xFF;
            data[ 7 ]                               = 0;
            data[ 8 ]                               = 0;
            i2c.write( I2C_ADDRESS, data, 9 );

            count++;
            wait( 0.002 );
        }

        for ( count = 0; count < 2048; count++ ) {
            data[ 3 + (((count >> 8) + 2) % 3) ]    = 0xFF - (count & 0xFF);
            data[ 3 + (((count >> 8) + 1) % 3) ]    = 0x00;
            data[ 3 + (((count >> 8) + 0) % 3) ]    = count & 0xFF;
            data[ 7 ]                               = (count >>  9) & 0x1 ? 0x80 : 0x10;
            data[ 8 ]                               = (count >> 10) & 0x1 ?   23 :    2;
            i2c.write( I2C_ADDRESS, data, 9 );

            count++;
            wait( 0.01 );
        }
    }
}
