#include "mbed.h"
#include "PCA9632.h"

PCA9632     led_cntlr( p28, p27, 0xC4 );    //  SDA, SCL, Slave_address(option)
LedPwmOut   led0( led_cntlr, L0 );           //  for LED0 pin
LedPwmOut   led1( led_cntlr, L1 );           //  for LED0 pin

int main()
{
    //
    //  Here are two types of PWM control samples
    //  (User can choose one of those interface to set the PWM.)
    //
    //  1st sample is using LedPwmOut API.
    //    It provides similar interface like PwmOut of mbed-SDK
    //
    //  2nd sample is using PCA9632 class function.
    //    the 'pwm()' function takes LED channel number and duty-ratio value
    //

    while ( 1 ) {

        //
        //  1st sample is using LedPwmOut API.
        //  PWM control via LedPwmOut
        //
        for ( int i = 0; i < 3; i++ ) {
            for( float p = 0.0f; p < 1.0f; p += 0.01f ) {
                led0    = p;        //  Controls LED0 pin
                led1    = 1.0 - p;  //  Controls LED1 pin
                wait( 0.01 );
            }
        }

        led0    = 0.0;
        led1    = 0.0;

        //
        //  2nd sample is using PCA9632 class function.
        //  PWM control by device class function call
        //
        for ( int i = 0; i < 3; i++ ) {
            for( float p = 0.0f; p < 1.0f; p += 0.01f ) {
                led_cntlr.pwm( 2, p );          //  Controls LED2 pin
                led_cntlr.pwm( 3, 1.0 - p );    //  Controls LED3 pin
                wait( 0.01 );
            }
        }
        
        led_cntlr.pwm( 2, 0.0 );
        led_cntlr.pwm( 3, 0.0 );
    }
}
