#include "mbed.h"
#include "PCA9632.h"

PCA9632     led_cntlr( p28, p27, 0xC4 );    //  SDA, SCL, Slave_address(option)
LedPwmOut   led( led_cntlr, L0 );           //  for LED0 pin

int main()
{
    //
    //  Here are two types of PWM control samples
    //  (User can choose one of those interface to set the PWM.)
    //
    //  1st sample is using LedPwmOut API.
    //    It provides similar interface like PwmOut of mbed-SDK
    //
    //  2nd sample is using PCA9632 class function.
    //    the 'pwm()' function takes LED channel number and duty-ratio value
    //

    while ( 1 ) {
        
        //
        //  1st sample is using LedPwmOut API.
        //  PWM control via LedPwmOut
        //
        for ( int i = 0; i < 3; i++ ) {
            for( float p = 0.0f; p < 1.0f; p += 0.1f ) {
                led     = p;  //  Controls LED0 pin
                wait( 0.1 );
            }
        }

        //
        //  2nd sample is using PCA9632 class function.
        //  PWM control by device class function call
        //
        for ( int i = 0; i < 3; i++ ) {
            for( float p = 0.0f; p < 1.0f; p += 0.1f ) {
                led_cntlr.pwm( 1, p );  //  Controls LED1 pin
                wait( 0.1 );
            }
        }
    }
}
