#include    "mbed.h"
#include    "PCA9632.h"

PCA9632::PCA9632( PinName i2c_sda, PinName i2c_scl, char i2c_address )
    : i2c_p( new I2C( i2c_sda, i2c_scl ) ), i2c( *i2c_p ), address( i2c_address )
{
    initialize();
}

PCA9632::PCA9632( I2C &i2c_, char i2c_address )
    : i2c_p( NULL ), i2c( i2c_ ), address( i2c_address )
{
    initialize();
}

PCA9632::~PCA9632()
{
    if ( NULL != i2c_p )
        delete  i2c_p;
}

void PCA9632::initialize( void )
{
    char init_array0[] = {
        AUTO_INCREMENT | REGISTER_START,   //  Command
        0x01, 0x00,                        //  MODE1, MODE2
    };
    char init_array1[] = {
        AUTO_INCREMENT | LEDOUT,           //  Command
        0xAA,                              //  LEDOUT
    };

    write( init_array0, sizeof( init_array0 ) );
    write( init_array1, sizeof( init_array1 ) );
}

void PCA9632::reset( void )
{
    char    va[]    = { 0xA5, 0x5A };
    i2c.write( 0x06, va, sizeof( va ) );
}

void PCA9632::pwm( int port, float v )
{
    char    reg_addr;

    if ( port < N_OF_PORTS ) {
        reg_addr    = PWM_REGISTER_START + port;
        write( reg_addr, (char)(v * 255.0) );
    } else {
        float   va[ N_OF_PORTS ];

        for ( int i = 0; i < N_OF_PORTS; i++ )
            va[ i ]  = v;

        pwm( va );
    }
}

void PCA9632::pwm( float *vp )
{
    char    data[ N_OF_PORTS + 1 ];

    *data    = PWM_REGISTER_START;

    for ( int i = 1; i <= N_OF_PORTS; i++ )
        data[ i ]   = (char)(*vp++ * 255.0);

    write( data, sizeof( data ) );
}

void PCA9632::write( char *data, int length )
{
    *data   |= AUTO_INCREMENT;
    i2c.write( address, data, length );
}

void PCA9632::write( char reg_addr, char data )
{
    char    c[2];

    c[0]    = reg_addr;
    c[1]    = data;

    i2c.write( address, c, 2 );
}

void PCA9632::read( char reg_addr, char *data, int length )
{
    reg_addr    |= 0x80;
    i2c.write( address, (char *)(&reg_addr), 1, true );
    i2c.read(  address, data, length );
}

char PCA9632::read( char reg_addr )
{
    i2c.write( address, (char *)(&reg_addr), 1, true );
    i2c.read(  address, (char *)(&reg_addr), 1 );

    return ( reg_addr );
}
