/** LedPwmOut class for LED driver component
 *
 *  @author  Akifumi (Tedd) OKANO, NXP Semiconductors
 *  @version 0.5
 *  @date    04-Mar-2015
 *
 *  Released under the Apache 2 license License
 */

#ifndef     MBED_LedPwmOut
#define     MBED_LedPwmOut

#include    "mbed.h"
#include    "CompLedDvr.h"

/** LedPwmOut class
 *
 *  "LedPwmOut" class works like "PwmOut" class of mbed-SDK. 
 *  This class provides API on device's pin level with abstracting the LED controller. 
 *
 *  Example:
 *  @code
 *  #include "mbed.h"
 *  #include "PCA9632.h"
 *  
 *  PCA9632     led_cntlr( p28, p27, 0xC4 );  //  SDA, SCL, Slave_address(option)
 *  LedPwmOut   led( led_cntlr, L0 );
 *  
 *  int main()
 *  {
 *      while( 1 ) {
 *          for( float p = 0.0f; p < 1.0f; p += 0.1f ) {
 *              led     = p;
 *              wait( 0.1 );
 *          }
 *      }
 *  }
 *  @endcode
 */


class LedPwmOut
{
public:
    LedPwmOut( CompLedDvr &ledp, LedPinName pin_name );
    virtual ~LedPwmOut();

    virtual void    pwm( float v );

    /** A shorthand for write()
     */
    LedPwmOut&      operator= ( float rhs );

private:
    CompLedDvr      *leddvrp;
    LedPinName      pin;

    void    pwm( int pin, float value );
}
;

#endif  //  MBED_LedPwmOut
