/** Abstract class for LED driver component
 *
 *  Abstract class for LED driver family
 *  No instance can be made from this class
 *
 *  @author  Akifumi (Tedd) OKANO, NXP Semiconductors
 *  @version 0.5
 *  @date    04-Mar-2015
 *
 *  Released under the Apache 2 license License
 */

#ifndef     MBED_CompLedDvr
#define     MBED_CompLedDvr

#include    "mbed.h"

typedef enum {
    /** Pin names of LED driver. Those are L0 .. L3, not like "LED0" to avoid mbed board LED names  */
    L0,             /**< LED0 pin                               */
    L1,             /**< LED1 pin                               */
    L2,             /**< LED2 pin                               */
    L3,             /**< LED3 pin                               */
    L_NC = ~0x0L    /**< for when the pin is left no-connection */
} LedPinName;


/** Abstract class for LED driver component
 *
 *  @class CompLedDvr
 *
 *  Abstract class for LED driver family
 *  No instance can be made from this class
 */
class CompLedDvr
{
public:
    /** Default constructor */
    CompLedDvr();

    /** Destructor */
    virtual ~CompLedDvr();

    /** Virtual function to define standard function of the component   */
    virtual void    pwm( int port, float v )    = 0;
}
;

#endif  //  MBED_CompLedDvr


