/** PCA962x PWM control LED driver family
 *
 *  Abstract class for PCA962x family
 *  No instance can be made from this class
 *
 *  @class   PCA962x
 *  @author  Akifumi (Tedd) OKANO, NXP Semiconductors
 *  @version 0.6
 *  @date    04-Mar-2015
 *
 *  Released under the Apache 2 license License
 */

#ifndef     MBED_PCA962x
#define     MBED_PCA962x

#include    "mbed.h"
#include    "CompLedDvr.h"

#define     ALLPORTS        0xFF
#define     DEFAULT_PWM     1.0

/** PCA962x class
 *
 *  Abstract class for PCA962x family
 *  No instance can be made from this class
 */
class PCA962x : public CompLedDvr
{
public:
    PCA962x( PinName i2c_sda, PinName i2c_scl, char i2c_address = DEFAULT_I2C_ADDR );
    PCA962x( I2C &i2c_obj, char i2c_address = DEFAULT_I2C_ADDR );
    virtual ~PCA962x();

    void            reset( void );

    virtual void    pwm( int port, float v );
    
    void            pwm( float *vp );
    virtual int     number_of_ports( void )             = 0;

    void            write( char reg_addr, char data );
    void            write( char *data, int length );
    char            read( char reg_addr );
    void            read( char reg_addr, char *data, int length );

protected:
    enum {
        DEFAULT_I2C_ADDR    = 0xC0,
        AUTO_INCREMENT      = 0x80,
        PWMALL              = 0xFF
    };

private:
    virtual void    initialize( void )                  = 0;
    virtual char    pwm_register_access( int port )     = 0;

    I2C             *i2c_p;
    I2C             &i2c;
    char            address;    //  I2C slave address
}
;

#endif  //  MBED_PCA962x
