#include    "mbed.h"
#include    "PCA962x.h"

PCA962x::PCA962x( PinName i2c_sda, PinName i2c_scl, char i2c_address )
    : i2c_p( new I2C( i2c_sda, i2c_scl ) ), i2c( *i2c_p ), address( i2c_address )
{
}

PCA962x::PCA962x( I2C &i2c_, char i2c_address )
    : i2c_p( NULL ), i2c( i2c_ ), address( i2c_address )
{
}

PCA962x::~PCA962x()
{
    if ( NULL != i2c_p )
        delete  i2c_p;
}

void PCA962x::reset( void )
{
    char    va[]    = { 0xA5, 0x5A };
    i2c.write( 0x06, va, sizeof( va ) );
}

void PCA962x::pwm( int port, float v )
{
    char    reg_addr;

    reg_addr    = pwm_register_access( port );

    if ( PWMALL == reg_addr ) {
        int     np  = number_of_ports();
        float   va[ np ];
        
        for ( int i = 0; i < np; i++ )
            va[ i ]  = v;

        pwm( va );
        
    } else {
        write( reg_addr, (char)(v * 255.0) );
    }
}

void PCA962x::pwm( float *vp )
{
    int     n_of_ports  = number_of_ports();
    char    data[ n_of_ports + 1 ];

    *data    = pwm_register_access( 0 );

    for ( int i = 1; i <= n_of_ports; i++ )
        data[ i ]   = (char)(*vp++ * 255.0);

    write( data, sizeof( data ) );
}

void PCA962x::write( char *data, int length )
{
    *data   |= AUTO_INCREMENT;
    i2c.write( address, data, length );
}

void PCA962x::write( char reg_addr, char data )
{
    char    c[2];

    c[0]    = reg_addr;
    c[1]    = data;

    i2c.write( address, c, 2 );
}

void PCA962x::read( char reg_addr, char *data, int length )
{
    reg_addr    |= 0x80;
    i2c.write( address, (char *)(&reg_addr), 1, true );
    i2c.read(  address, data, length );
}

char PCA962x::read( char reg_addr )
{
    i2c.write( address, (char *)(&reg_addr), 1, true );
    i2c.read(  address, (char *)(&reg_addr), 1 );

    return ( reg_addr );
}
