#include    "mbed.h"
#include    "PCA9626.h"

PCA9626::PCA9626( PinName i2c_sda, PinName i2c_scl, char i2c_address )
    : PCA962x( i2c_sda, i2c_scl, i2c_address ), n_of_ports( 24 )
{
    initialize();
}

PCA9626::PCA9626( I2C &i2c_obj, char i2c_address )
    : PCA962x( i2c_obj, i2c_address ), n_of_ports( 24 )
{
    initialize();
}

PCA9626::~PCA9626()
{
}

void PCA9626::initialize( void )
{
    char init_array0[] = {
            PCA962x::AUTO_INCREMENT | REGISTER_START,           //  Command
            0x01, 0x00,                                         //  MODE1, MODE2
        };
    char init_array1[] = {
            PCA962x::AUTO_INCREMENT | LEDOUT_REGISTER_START,    //  Command
            0xAA, 0xAA, 0xAA, 0xAA, 0xAA, 0xAA,                 //  LEDOUT[5:0]
        };

    write( init_array0, sizeof( init_array0 ) );
    write( init_array1, sizeof( init_array1 ) );
}

char PCA9626::pwm_register_access( int port )
{
    if ( port < n_of_ports )
        return ( PWM_REGISTER_START + port );

    return ( PWMALL );
}

int PCA9626::number_of_ports( void )
{
    return ( n_of_ports );
}
