/**
 *  Sample code to operate 6 of PCA9622_LED8x8 module
 *
 *  @author  Tedd OKANO
 *  @version 1.0
 *  @date    25-Dec-2014
 */

#include "mbed.h"
#include "PCA9622_LED8x8.h"

I2C  i2c( p28, p27 );

PCA9622_LED8x8  matrix[]    = {
    PCA9622_LED8x8( i2c, 0xA0 ),
    PCA9622_LED8x8( i2c, 0xA2 ),
    PCA9622_LED8x8( i2c, 0xA4 ),
    PCA9622_LED8x8( i2c, 0xA6 ),
    PCA9622_LED8x8( i2c, 0xA8 ),
    PCA9622_LED8x8( i2c, 0xAA )
};

static char bm_nxp[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,

    0xFF, 0xFF, 0xFF, 0xF0, 0x78, 0x3C, 0x1E, 0x0F,
    0xFF, 0x7E, 0xBD, 0xDB, 0xE7, 0x7E, 0x3C, 0x18,
    0x3C, 0x7E, 0xE7, 0xDB, 0xBD, 0x7E, 0xFF, 0xCC,
    0xCC, 0xCC, 0xCC, 0xCC, 0xFC, 0x78, 0x78,

    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
};

#define     N_OF_MTX    6

int main()
{
    float   image[ 8 ][ 8 ];
    int     index;
    int     count   = 0;

    while(1) {

        for ( int offset = 0; offset < N_OF_MTX; offset++) {
            index       = ((count + offset * 11) % (sizeof( bm_nxp ) - 8));
            for ( int i = 0; i < 8; i++ ) {
                for ( int j = 0; j < 8; j++ ) {
                    image[ j ][ 7 - i ]   = (bm_nxp[ index + j ] >> (7 - i)) & 0x1;
                }
            }
            matrix[ offset ].set_data( image );
        }

        count++;
        wait( 0.02 );
    }
}
