/**
 *  A hello world code for the PCA9622 LED 8x8 library
 *
 *  @author  Tedd OKANO
 *  @version 1.1
 *  @date    25-Dec-2014
 *
 *  This is a very simple sample code for the PCA9622_LED8x8 library. 
 *  Target hardware : "I2C 8x8 LED matrix board" from Switch Science
 *    https://www.switch-science.com/catalog/2071/
 *
 *  The I2C LED controller PCA9622 is used on this module 
 *  that ebables to control the LEDs with PWM brightness control. 
 *  
 *  For more information about the PCA9622:
 *    http://www.nxp.com/documents/data_sheet/PCA9622.pdf
 */

#include "mbed.h"
#include "PCA9622_LED8x8.h"

//  Choose a target platform from next list
PCA9622_LED8x8  matrix( p28, p27 );     //  for 40pin type mbed
//PCA9622_LED8x8  matrix( D14, D15 );   //  for Arduino type mbed
//PCA9622_LED8x8  matrix( dp5, dp27 );  //  for mbed LPC1114

float func( float x, float y, float t );    //  function to make 8x8 image

int main()
{
    float   image[ 8 ][ 8 ];  //  
    int     count   = 0;
    
    while(1) {
        
        //  making 8x8 image to "image" array
        for ( int i = 0; i < 8; i++ )
            for ( int j = 0; j < 8; j++ )
                image[ i ][ j ]   = func( i, j, count * 0.2 );

        //  set the image into library internal bufer
        matrix.set_data( image );

        count++;
        wait( 0.05 );
    }
}

float func( float x, float y, float t )
{
//#define     DISPLAY_OFFSET  3.5
#define     DISPLAY_OFFSET  0
#define     SIZE            0.3

    float   s;
    
    x   = (x - DISPLAY_OFFSET) * SIZE;
    y   = (y - DISPLAY_OFFSET) * SIZE;

    s   = cos( powf( x * x + y * y, 0.5 ) - t );
    return ( powf( s, 4.0 ) );
}
