/** A sample code for "mini board PCU9669/PCA9665"
 *
 *  @author  Akifumi (Tedd) OKANO, NXP Semiconductors
 *  @version 1.1
 *  @date    11-Jul-2012
 *
 *  Released under the MIT License: http://mbed.org/license/mit
 *
 *  An operation sample of PCU9669/PCA9665 I2C bus controller.
 *  The mbed accesses the bus controller's parallel port (8/2 bit address and 8 bit data) by bit-banging.
 *  The bit-banging is poerformed by PortInOut function of mbed library.
 *
 *    To make the code porting easier, all codes are partitioned into layers to abstract other parts.
 *    The mbed specific parts are concentrated in lowest layer: "hardware_abs.*".
 *    This module may need to be modified for the porting.
 *
 *    All other upper layers are writen in standard-C.
 *
 *    base code is written from 05-Sep-2011 to 09-Sep-2011.
 *    And demo code has been build on 11-Sep-2011.
 *    Debug and code adjustment has been done on 08-Sep-2011.
 *    Small sanitization for main.cpp. All mbed related codes are moved in to "hardware_abs.*". 13-Oct-2011
 *    hardware_abs are moved into parallel_bus library folder, 3 LED driver operation sample 13-Feb.-2012
 *    PCU9669 and PCA9665 codes are packed in a project 14-Feb-2012. 
 *    
 *    Before builidng the code, please edit the file mini_board_PCU9669/config.h
 *    Un-comment the target name what you want to target. 
 */


/** PCx9955 (PCU9955 and PCA9955) related definitions
 *  
 *  PCx9955's internal register name and address definitions, I2C address difinitions
 */

#ifndef MINIBOARD_PCx9955_REG__
#define MINIBOARD_PCx9955_REG__

/** @var Register names
 *
 *  PCx9955 internal register name and addesses
 */
typedef enum {
    MODE1   = 0x00,
    MODE2,
    LEDOUT0,
    LEDOUT1,
    LEDOUT2,
    LEDOUT3,
    GRPPWM  = 0x08,
    GRPFREQ,
    PWM0    = 0x0A,
    PWM1,
    PWM2,
    PWM3,
    PWM4,
    PWM5,
    PWM6,
    PWM7,
    PWM8,
    PWM9,
    PWM10,
    PWM11,
    PWM12,
    PWM13,
    PWM14,
    PWM15,
    IREF0   = 0x22,
    IREF1,
    IREF2,
    IREF3,
    IREF4,
    IREF5,
    IREF6,
    IREF7,
    IREF8,
    IREF9,
    IREF10,
    IREF11,
    IREF12,
    IREF13,
    IREF14,
    IREF15,
    OFFSET  = 0x3A,
    SUBADR1,
    SUBADR2,
    SUBADR3,
    ALLCALLADR,
    RESERVED1,
    RESERVED2,
    RESERVED3,
    PWMALL,
    IREFALL,
    EFLAG0,
    EFLAG1,

    REGISTER_START          = MODE1,
    LEDOUT_REGISTER_START   = LEDOUT0,
    PWM_REGISTER_START      = PWM0,
    IREF_REGISTER_START     = IREF0,
}
PCx9955_reg;

/** @var PCx9955 I2C bus addresses
 */
typedef enum {
    PCx9955_ADDR0   = 0xC0,
    PCx9955_ADDR1   = 0xC2,
    PCx9955_ADDR2   = 0xC4,
    PCx9955_ADDR3   = 0xC6,
    PCx9955_ADDR4   = 0xC8,
    PCx9955_ADDR5   = 0xCA,
    PCx9955_ADDR6   = 0xCC,
    PCx9955_ADDR7   = 0xCE,
    PCx9955_ADDR8   = 0xD0,
    PCx9955_ADDR9   = 0xD2,
    PCx9955_ADDRA   = 0xD4,
    PCx9955_ADDRB   = 0xD6,
    PCx9955_ADDRC   = 0xD8,
    PCx9955_ADDRD   = 0xDA,
    PCx9955_ADDRE   = 0xDC,
    PCx9955_ADDRF   = 0xDE
}
pcx9955_addr;


/** @def PWM_INIT / IREF_INIT
 *
 *  Initial value for the PWMn and IREFn registers
 */
#define     PWM_INIT        0x00
#define     IREF_INIT       0xFF

#endif  //  MINIBOARD_PCx9955_REG__