/** A sample code for "mini board PCU9669/PCA9665"
 *
 *  @author  Akifumi (Tedd) OKANO, NXP Semiconductors
 *  @version 1.1
 *  @date    11-Jul-2012
 *
 *  Released under the MIT License: http://mbed.org/license/mit
 *
 *  An operation sample of PCU9669/PCA9665 I2C bus controller.
 *  The mbed accesses the bus controller's parallel port (8/2 bit address and 8 bit data) by bit-banging.
 *  The bit-banging is poerformed by PortInOut function of mbed library.
 *
 *    To make the code porting easier, all codes are partitioned into layers to abstract other parts.
 *    The mbed specific parts are concentrated in lowest layer: "hardware_abs.*".
 *    This module may need to be modified for the porting.
 *
 *    All other upper layers are writen in standard-C.
 *
 *    base code is written from 05-Sep-2011 to 09-Sep-2011.
 *    And demo code has been build on 11-Sep-2011.
 *    Debug and code adjustment has been done on 08-Sep-2011.
 *    Small sanitization for main.cpp. All mbed related codes are moved in to "hardware_abs.*". 13-Oct-2011
 *    hardware_abs are moved into parallel_bus library folder, 3 LED driver operation sample 13-Feb.-2012
 *    PCU9669 and PCA9665 codes are packed in a project 14-Feb-2012. 
 *    
 *    Before builidng the code, please edit the file mini_board_PCU9669/config.h
 *    Un-comment the target name what you want to target. 
 */


/** PCA9629 related definitions
 *  
 *  PCA9629's internal register name and address definitions, I2C address difinitions
 */

#ifndef MINIBOARD_PCA9629_REG__
#define MINIBOARD_PCA9629_REG__


/** @var PCA9629 I2C bus addresses
 */

typedef enum {
    PCA9629_ADDR0   = 0x40,
    PCA9629_ADDR1   = 0x42,
    PCA9629_ADDR2   = 0x44,
    PCA9629_ADDR3   = 0x46,
    PCA9629_ADDR4   = 0x48,
    PCA9629_ADDR5   = 0x4A,
    PCA9629_ADDR6   = 0x4C,
    PCA9629_ADDR7   = 0x4E,
    PCA9629_ADDR8   = 0x50,
    PCA9629_ADDR9   = 0x52,
    PCA9629_ADDRA   = 0x54,
    PCA9629_ADDRB   = 0x56,
    PCA9629_ADDRC   = 0x58,
    PCA9629_ADDRD   = 0x5A,
    PCA9629_ADDRE   = 0x5C,
    PCA9629_ADDRF   = 0x5E,
}
pca9629_addr;


#endif  //  MINIBOARD_PCA9629_REG__


