/** Abstract class for LED driver component
 *
 *  Abstract class for LED driver family
 *  No instance can be made from this class
 *
 *  @author  Akifumi (Tedd) OKANO, NXP Semiconductors
 *  @version 0.5
 *  @date    04-Mar-2015
 *
 *  Released under the Apache 2 license License
 */

#ifndef     MBED_CompLedDvr
#define     MBED_CompLedDvr

#include    "mbed.h"

/** Pin names of LED driver. Those are L0 .. L3, not like "LED0" to avoid mbed board LED names  */
typedef enum {
    L0,            /**< LED0 pin                               */
    L1,            /**< LED2 pin                               */
    L2,            /**< LED2 pin                               */
    L3,            /**< LED2 pin                               */
    L4,            /**< LED2 pin                               */
    L5,            /**< LED2 pin                               */
    L6,            /**< LED2 pin                               */
    L7,            /**< LED2 pin                               */
    L8,            /**< LED2 pin                               */
    L9,            /**< LED2 pin                               */
    L10,           /**< LED2 pin                               */
    L11,           /**< LED2 pin                               */
    L12,           /**< LED2 pin                               */
    L13,           /**< LED2 pin                               */
    L14,           /**< LED2 pin                               */
    L15,           /**< LED2 pin                               */
    L16,           /**< LED2 pin                               */
    L17,           /**< LED2 pin                               */
    L18,           /**< LED2 pin                               */
    L19,           /**< LED2 pin                               */
    L20,           /**< LED2 pin                               */
    L21,           /**< LED2 pin                               */
    L22,           /**< LED2 pin                               */
    L23,           /**< LED23 pin                               */
    L_NC = ~0x0L   /**< for when the pin is left no-connection */
} LedPinName;


/** Abstract class for LED driver component
 *
 *  @class CompLedDvr
 *
 *  Abstract class for LED driver family
 *  No instance can be made from this class
 */
class CompLedDvr
{
public:
    /** Default constructor */
    CompLedDvr();

    /** Destructor */
    virtual ~CompLedDvr();

    /** Virtual function to define standard function of the component   */
    virtual void    pwm( int port, float v )    = 0;
}
;

#endif  //  MBED_CompLedDvr


