#include "MyColor.h"
#include "mbed.h"


MyColor::MyColor(PinName red, PinName green, PinName blue) : _red(red), _green(green), _blue(blue){
    _red.period(0.001f);
    _green.period(0.001f);
    _blue.period(0.001f);
}
    
void MyColor::write(float val) {
    for (; val < 1.0f ; val += 0.001f) {
        float p = 3 * val;
        _red = 1.0f - ((p < 1.0f) ? 1.0f - p : (p > 2.0f) ? p - 2.0f : 0.0f);
        _green = 1.0f - ((p < 1.0f) ? p : (p > 2.0f) ? 0.0f : 2.0f - p);
        _blue = 1.0 - ((p < 1.0) ? 0.0 : (p > 2.0) ? 3.0 - p : p - 1.0);
        wait (0.0025f);
    }
}


MyColor& MyColor::operator= (float f) {
write(f);
return *this;
}