#include "GoalCounter.h"

GoalCounter::GoalCounter(PinName pin, Timer * t) : _t(t) {
    
    InterruptIn *_interrupt = new InterruptIn(pin); // Initialize instace of InterruptIn
    // It has to be done dynamically because of non-copyable class
     
    _interrupt->fall(callback(this, &GoalCounter::tstart)); // Set callbacks to timer
    _interrupt->rise(callback(this, &GoalCounter::tstop));
    
    _score = 0;
    _time = 0;
    is_goal = 0;
    _begin = 0;
    _end = 0;
    _last_end = 0;
    _time_between = 0;
    
    _t->start(); 
}

GoalCounter::~GoalCounter()
{
    delete[] _interrupt; // free up dynamically allocated memory
}
         
void GoalCounter::tstart() {
    _begin = _t->read(); // read value of the timer
}

void GoalCounter::tstop() {
    _end = _t->read();
    _time = _end - _begin;
    _time_between = _begin - _last_end;

    if ( _time > 0 && _time < 2 && _score < 10  && _time_between > 1) {
       _score++;
       _balltimes[_score] = _time;
       _last_end = _end;
       is_goal = 1;
    }     
}


uint8_t GoalCounter::get_score() {
    return _score;
}

float GoalCounter::get_balltime(uint8_t score) {
    if (score <= _score && score > 0)
        return _balltimes[score];
    else
        return -1;   
}

float GoalCounter::get_balltime() {
    return _balltimes[_score];
 
}

float GoalCounter::get_ballspeed(uint8_t score) {
    if (score <= _score && score > 0) {
        float speed = 0.034f/_balltimes[score]*3.6f;
        return speed;
    }
    else
        return -1;   
}

float GoalCounter::get_ballspeed() {
    float speed = 0.034f/_balltimes[_score]*3.6f;
    return speed;
}
