#include "mbed.h"
#include "max32630fthr.h"
#include "USBSerial.h"
//#include "string.h"

#define LF21_I2C_WRITE 0xD2
#define LF21_I2C_READ 0xD3

// Hardware serial port over DAPLink
Serial daplink(P2_1, P2_0);

// Virtual serial port over USB
USBSerial microUSB;

SPI spi(P5_1, P5_2, P5_0); // mosi, miso, sclk
I2C *i2c;
DigitalOut spicsb(P4_0); // spi csb line
PwmOut *pwm;

DigitalOut p3_0(P3_0);
DigitalOut p3_1(P3_1);
DigitalOut p3_2(P3_2);
DigitalOut p3_3(P3_3);
DigitalOut p5_3(P5_3);
DigitalOut p5_4(P5_4);
DigitalOut p5_5(P5_5);
DigitalOut p5_6(P5_6);

DigitalOut rLED(LED1);
DigitalOut gLED(LED2);
DigitalOut bLED(LED3);
MAX32630FTHR pegasus(MAX32630FTHR::VIO_1V8);

int ascii(char a, char b);
int ldo(char a, char b);

// main() runs in its own thread in the OS
// (note the calls to Thread::wait below for delays)
int main()
{
    char buf[10];
    
    gLED = LED_OFF;
    bLED = LED_ON;
    rLED = LED_OFF;
    spi.format(8,0);
    spicsb = 1;
    pegasus.max14690.ldo3SetVoltage(1800);
    wait(1.0);
    //i2c.frequency(100000);
    
    p3_0 = 0;
    p3_1 = 1;
    
    p3_2 = 1;
    p3_3 = 0;
    
    p5_3 = 1;
    p5_4 = 0;
    
    p5_5 = 1;
    p5_6 = 1;
    
    while(1) {
        
        microUSB.scanf("%s", buf);
        
        // ping command, responds with pong
        if(buf[0]=='p' && buf[1]=='i' && buf[2]=='n' && buf[3]=='g') {
            microUSB.printf("pong\r\n");
            gLED=LED_OFF;
            wait(0.01);
            gLED=LED_ON;
            wait(0.01);
            gLED=LED_OFF;
        }
        // spi write command: spiw.addr.data
        // addr and data in hex
        else if (buf[0]=='s' && buf[1]=='p' && buf[2]=='i' && buf[3]=='w') {
            int resp = 0;
            char payload[2];
            char response[2];
            payload[0] = ascii((int)buf[5],(int)buf[6]);
            payload[1] = ascii((int)buf[8],(int)buf[9]);
            spicsb = 0;
            resp = spi.write(payload, sizeof(payload), response, sizeof(response));
            spicsb = 1;
            microUSB.printf("ack.%i\r\n",resp);
            gLED=LED_OFF;
            wait(0.01);
            gLED=LED_ON;
            wait(0.01);
            gLED=LED_OFF;
        }
        
        // spi transmit command
        // write to SPITX_EN register and leave CS low
        else if (buf[0]=='s' && buf[1]=='p' && buf[2]=='i' && buf[3]=='t') {
            int resp = 0;
            char payload[2];
            char response[2];
            payload[0] = ascii((int)buf[5],(int)buf[6]);
            payload[1] = ascii((int)buf[8],(int)buf[9]);
            spicsb = 0;
            resp = spi.write(payload, sizeof(payload), response, sizeof(response));
            microUSB.printf("ack.%i\r\n",resp);
            gLED=LED_OFF;
            wait(0.01);
            gLED=LED_ON;
            wait(0.01);
            gLED=LED_OFF;
        }
        
        // set csb high
        else if (buf[0]=='c' && buf[1]=='s' && buf[2]=='b' && buf[3]=='h') {
            spicsb = 1;
            microUSB.printf("ack\r\n");
            gLED=LED_OFF;
            wait(0.01);
            gLED=LED_ON;
            wait(0.01);
            gLED=LED_OFF;
        }
        
        else if (buf[0]=='p' && buf[1]=='w' && buf[2]=='m' && buf[3]=='o') {
            pwm = new PwmOut(P3_4);
            pwm->period_us(20);
            pwm->write(0.50f);
            
            microUSB.printf("ack\r\n");
            gLED=LED_OFF;
            wait(0.01);
            gLED=LED_ON;
            wait(0.01);
            gLED=LED_OFF;
        }
        
        else if (buf[0]=='t' && buf[1]=='e' && buf[2]=='s' && buf[3]=='t') {
            pwm = new PwmOut(P3_4);
            pwm->period(0.5f);
            pwm->write(0.50f);
            
            microUSB.printf("ack\r\n");
            gLED=LED_OFF;
            wait(0.01);
            gLED=LED_ON;
            wait(0.01);
            gLED=LED_OFF;
        }
        
        // spi read command: spir.addr
        else if (buf[0]=='s' && buf[1]=='p' && buf[2]=='i' && buf[3]=='r') {
            int resp = 0;
            char payload[2];
            char response[2];
            payload[0] = ascii((int)buf[5],(int)buf[6]);
            payload[1] = 0x00;
            spicsb = 0;
            resp = spi.write(payload, sizeof(payload), response, sizeof(response));
            spicsb = 1;
            microUSB.printf("ack.%i.%i\r\n", response[1], resp);
            gLED=LED_OFF;
            wait(0.01);
            gLED=LED_ON;
            wait(0.01);
            gLED=LED_OFF;
        }
        
        // i2c write command: i2cw.addr.data
        else if (buf[0]=='i' && buf[1]=='2' && buf[2]=='c' && buf[3]=='w') {
            i2c = new I2C(P3_4, P3_5);
            int response = 0;
            char payload[2];
            payload[0] = ascii((int)buf[5],(int)buf[6]);
            payload[1] = ascii((int)buf[8],(int)buf[9]);
            response = i2c->write(LF21_I2C_WRITE, payload, sizeof(payload));
            microUSB.printf("ack.%i\r\n", response);
            gLED=LED_OFF;
            wait(0.01);
            gLED=LED_ON;
            wait(0.01);
            gLED=LED_OFF;
        }
        // i2c read command: i2cr.addr
        else if (buf[0]=='i' && buf[1]=='2' && buf[2]=='c' && buf[3]=='r') {
            i2c = new I2C(P3_4, P3_5);
            int response = 0;
            char address[1];
            char payload[1];
            payload[0] = 0xFF;
            address[0] = ascii((int)buf[5],(int)buf[6]);
            response = i2c->write(LF21_I2C_WRITE, address, sizeof(address), true);
            response = i2c->read(LF21_I2C_READ, payload, sizeof(payload));
            microUSB.printf("ack.%i.%i\r\n", response, payload[0]);
            gLED=LED_OFF;
            wait(0.01);
            gLED=LED_ON;
            wait(0.01);
            gLED=LED_OFF;
        }
        
        // digital pin p5_5
        else if (buf[0]=='p' && buf[1]=='5' && buf[2]=='_' && buf[3]=='5') {
            if (buf[5]=='1') p5_5 = 1;
            else p5_5 = 0;
            microUSB.printf("ack\r\n");
            gLED=LED_OFF;
            wait(0.01);
            gLED=LED_ON;
            wait(0.01);
            gLED=LED_OFF;
        }
        // digital pin p5_6
        else if (buf[0]=='p' && buf[1]=='5' && buf[2]=='_' && buf[3]=='6') {
            if (buf[5]=='1') p5_6 = 1;
            else p5_6 = 0;
            microUSB.printf("ack\r\n");
            gLED=LED_OFF;
            wait(0.01);
            gLED=LED_ON;
            wait(0.01);
            gLED=LED_OFF;
        }
        // digital pin p5_3
        else if (buf[0]=='p' && buf[1]=='5' && buf[2]=='_' && buf[3]=='3') {
            if (buf[5]=='1') p5_3 = 1;
            else p5_3 = 0;
            microUSB.printf("ack\r\n");
            gLED=LED_OFF;
            wait(0.01);
            gLED=LED_ON;
            wait(0.01);
            gLED=LED_OFF;
        }
        // digital pin p5_4
        else if (buf[0]=='p' && buf[1]=='5' && buf[2]=='_' && buf[3]=='4') {
            if (buf[5]=='1') p5_4 = 1;
            else p5_4 = 0;
            microUSB.printf("ack\r\n");
            gLED=LED_OFF;
            wait(0.01);
            gLED=LED_ON;
            wait(0.01);
            gLED=LED_OFF;
        }
        // digital pin p3_1
        else if (buf[0]=='p' && buf[1]=='3' && buf[2]=='_' && buf[3]=='1') {
            if (buf[5]=='1') p3_1 = 1;
            else p3_1 = 0;
            microUSB.printf("ack\r\n");
            gLED=LED_OFF;
            wait(0.01);
            gLED=LED_ON;
            wait(0.01);
            gLED=LED_OFF;
        }
        // digital pin p3_0
        else if (buf[0]=='p' && buf[1]=='3' && buf[2]=='_' && buf[3]=='0') {
            if (buf[5]=='1') p3_0 = 1;
            else p3_0 = 0;
            microUSB.printf("ack\r\n");
            gLED=LED_OFF;
            wait(0.01);
            gLED=LED_ON;
            wait(0.01);
            gLED=LED_OFF;
        }
        // digital pin p3_3
        else if (buf[0]=='p' && buf[1]=='3' && buf[2]=='_' && buf[3]=='3') {
            if (buf[5]=='1') p3_3 = 1;
            else p3_3 = 0;
            microUSB.printf("ack\r\n");
            gLED=LED_OFF;
            wait(0.01);
            gLED=LED_ON;
            wait(0.01);
            gLED=LED_OFF;
        }
        // digital pin p3_2
        else if (buf[0]=='p' && buf[1]=='3' && buf[2]=='_' && buf[3]=='2') {
            if (buf[5]=='1') p3_2 = 1;
            else p3_2 = 0;
            microUSB.printf("ack\r\n");
            gLED=LED_OFF;
            wait(0.01);
            gLED=LED_ON;
            wait(0.01);
            gLED=LED_OFF;
        }
        // set ldo voltage
        else if (buf[0]=='l' && buf[1]=='d' && buf[2]=='o') {
            int setting = ldo((int)buf[4],(int)buf[5]);
            pegasus.max14690.ldo3SetVoltage(setting*100);
            microUSB.printf("ack.%i\r\n",setting);
            gLED=LED_OFF;
            wait(0.01);
            gLED=LED_ON;
            wait(0.01);
            gLED=LED_OFF;
        }
    }
    
    
}

int ascii(char a, char b)
{
    int val1 = 0;
    int val2 = 0;
    int val = 0;
    if(a>64 && a<71)
    {
        val1 = (int)a-55;
    }
    else if(a>96 && a<103)
    {
        val1 = (int)a-87;
    }
    else val1 = (int)a-48;
    
    if(b>64 && b<71)
    {
        val2 = (int)b-55;
    }
    else if(b>96 && b<103)
    {
        val2 = (int)b-87;
    }
    else val2 = (int)b-48;
    
    val=16*val1+val2;
    
    return val;
}

int ldo(char a, char b)
{
    int val1 = 0;
    int val2 = 0;
    int val = 0;
    if(a>64 && a<71)
    {
        val1 = (int)a-55;
    }
    else if(a>96 && a<103)
    {
        val1 = (int)a-87;
    }
    else val1 = (int)a-48;
    
    if(b>64 && b<71)
    {
        val2 = (int)b-55;
    }
    else if(b>96 && b<103)
    {
        val2 = (int)b-87;
    }
    else val2 = (int)b-48;
    
    val=10*val1+val2;
    
    return val;
}    