#include "mbed.h"
#include "uLCD_4DGL.h"
#include "LSM9DS1.h"


uLCD_4DGL uLCD(p13, p14, p12);

Serial pc(USBTX,USBRX);

LSM9DS1 imu(p9, p10, 0xD6, 0x3C);


int main() {

    // Center Location
    int start_x_pos = 130 / 2;
    int start_y_pos = 130 /2;
    
    imu.calibrate();
    
    
    // Starting Location
    int x_pos = imu.gx;
    int y_pos = imu.gy;
    
    // Draw big circle
    uLCD.circle(start_x_pos, start_y_pos, start_x_pos, GREEN);
    
    
    uLCD.circle(start_x_pos, start_y_pos, 8, GREEN);
    // Draw small filled circle
    uLCD.filled_circle(x_pos, y_pos, 8, RED);
    
}






