#include "mbed.h"
#include "hcsr04.h"
#include "Solenoid.h"
#include "RGBled.h"
#include "Speaker.h"
#include "C12832.h"
#include <iostream>

HCSR04 sensor(p9, p10);
Solenoid mySolenoid (p18);
Solenoid mySolenoid_2 (p19);
RGBled  redled(p24);
RGBled  greenled(p23);
C12832 lcd(p5, p7, p6, p8, p11);
InterruptIn MagSense(p16);
Speaker Interrupt(p26);
DigitalOut myled1(LED1);

void flip()
{
    while(1) {
        if (mySolenoid.SetSolenoidStatus (false)){
            Interrupt.PlayNote(969, 0.1, 1.0);      // When contact is broken, interrupt the main program and sound the alarm and perform flip funtion
            Interrupt.PlayNote(800, 0.1, 1.0);
            lcd.locate (0,0);
            lcd.printf("Door Open               ");
            redled.SetRGBledStatus (true);
            greenled.SetRGBledStatus (false);
            }
            if (MagSense.read() == 0) { // when magsensor is not broken break the loop
                break; 
            }
    }
}
int main()
{
    redled.SetRGBledStatus (false);
    greenled.SetRGBledStatus (false);
    float distance = sensor.distance();  //constantly read floating distance
    MagSense.rise(&flip);
    lcd.cls();
    while(1) {
        float distance = sensor.distance();
        if (mySolenoid.SetSolenoidStatus (false)) {
                    greenled.SetRGBledStatus (false);
                    redled.SetRGBledStatus (true);
                    lcd.locate(0,0);
                    lcd.printf("**UNLOCKED**               ");
                }
        if (distance < 7)  {
            while (1) {
                mySolenoid.SetSolenoidStatus (true);
                mySolenoid_2.SetSolenoidStatus (true);
                if (mySolenoid.SetSolenoidStatus (true)) {
                    greenled.SetRGBledStatus (true);
                    redled.SetRGBledStatus (false);
                    lcd.locate(0,0);
                    lcd.printf("**LOCKED**             ");
                }              
            }
        } else if (distance > 7) {
            printf("distance =  %f\n",distance);
            wait(0.5); // 1 sec
        }
    }

}

