 #include "functions.h"
#include "SimpleSocket.h"
#include "EthernetInterface.h"
#include "mbed.h"

DigitalOut led0(LED1);
DigitalOut led1(LED2);

int main()
{

    EthernetInterface::init("192.169.1.201", "255.255.255.0", NULL);
    EthernetInterface::connect();
    ServerSocket server(80);
    led0.write(1);

    printf("server: %s:1234\n", EthernetInterface::getIPAddress());

    while (1) {
        ClientSocket socket = server.accept();

        if (socket) {
            while (socket) {
                char buf[80];
                int len = socket.read(buf, sizeof(buf));
                if(buf[0]=='a')
                led0=0;
                led1=!led1;
                wait(2);
                //if (len > 0)
                    socket.write(12);
                    wait_ms(2);
            }
            socket.close();
            wait_ms(2);
        }
        wait(1.0);
    }
}