#include "SimpleSocket.h"

typedef unsigned long long Time64;

Time64 toTime64(char buf[]) {
    Time64 time64 = 0;
    for (int i = 0; i < 8; i++) {
        time64 = (time64 << 8) | buf[i];
    }
    return time64;
}

Time64 toTime64(int usecs) {
    return Time64(double(usecs) * (1ULL << 32) / 1000000);
}

void printTime64(char *title, Time64 time64) {
    unsigned long seconds = (unsigned long) (time64 >> 32);
    unsigned long subsecs = (unsigned long) (time64 & 0xFFFFFFFFULL);
    char buf[16];

    time_t jstime = time_t(seconds - 2208988800UL) + 9 * 3600;
    strftime(buf, sizeof(buf), "%m/%d %X", localtime(&jstime));
    printf("%s: %s", title, buf);
    sprintf(buf, "%f\n", (double) subsecs / (1ULL << 32));
    printf("%s", &buf[1]);
}

void ntpclient2() {
    char *NTP_SERVER = "pool.ntp.org";
    char buf[48] = {0x23};// 00100011 LI(0), Version(4), Mode(3: Client)
    Timer timer;
    Time64 adjustedTime = 0;

    for (int count = 0; count < 5; count++) {
        buf[0] = 0x23;
        DatagramSocket datagram;
        datagram.write(buf, sizeof(buf));
        timer.reset();
        datagram.send(NTP_SERVER, 123);
        timer.start();
        if (datagram.receive() > 0) {
            int turnaround = timer.read_us();
            if (datagram.read(buf, sizeof(buf))) {
                Time64 receivedTime = toTime64(&buf[32]);
                Time64 transferTime = toTime64(&buf[40]);
                adjustedTime = toTime64(turnaround / 2) + receivedTime / 2 + transferTime / 2;
                timer.reset();
                timer.start();
                printTime64("transfer", transferTime);
                printTime64("adjusted", adjustedTime);
                printf("\n");
            }
        } else {
            wait(5);
        }
    }

    float subsecs = (double) (adjustedTime & 0xFFFFFFFFULL) / (1ULL << 32);
    wait(1 - subsecs);
    set_time((size_t) ((adjustedTime >> 32) - 2208988800UL) + 1);

    time_t jstime = time(NULL) + 9 * 3600;
    strftime(buf, sizeof(buf), "%m/%d %X", localtime(&jstime));
    printf("RTC delta = %6d, %s\n\n", timer.read_us(), buf);

    for (int count = 0; count < 20; count++) {
        buf[0] = 0x23;
        DatagramSocket datagram;
        datagram.write(buf, sizeof(buf));
        timer.reset();
        datagram.send(NTP_SERVER, 123);
        timer.start();
        if (datagram.receive() > 0) {
            int turnaround = timer.read_us();
            if (datagram.read(buf, sizeof(buf))) {
                Time64 receivedTime = toTime64(&buf[32]);
                Time64 transferTime = toTime64(&buf[40]);
                adjustedTime = toTime64(turnaround / 2) + receivedTime / 2 + transferTime / 2;  
                printTime64("adjusted", adjustedTime);
                time_t jstime = time(NULL) + 9 * 3600;
                strftime(buf, sizeof(buf), "%m/%d %X", localtime(&jstime));
                printf("     RTC: %s\n\n", buf);
            }
        } else {
            wait(5);
        }
    }

}