#include "mbed.h"
#include "Adafruit_SSD1306.h"

DigitalOut myled_R(LED_RED);

// SPI sub-class that provides a constructed default
class SPIPreInit : public SPI
{
public:
    SPIPreInit(PinName mosi, PinName miso, PinName clk) : SPI(mosi,miso,clk)
    {
        format(8,3);
        frequency(2000000);
    };
};

SPIPreInit gSpi(dp5,NC,dp6);
Adafruit_SSD1306_Spi myOled(gSpi,dp2,dp3,dp4);

int main()
{   
    uint16_t x=0;
 
    myOled.begin();
    myOled.printf("%ux%u Hellow World\r\n", myOled.width(), myOled.height());
    myOled.display();

    while(1)
    {
        myled_R = !myled_R;
        myOled.printf("%Irita=%u\r",x);
        myOled.display();
        x = x + 1;                  
        //wait(1.0);
    }
}
