#ifndef LCD_H_
#define LCD_H_ LCD_H_

#include <mbed.h>

#define LCD_X_SIZE 97
#define LCD_Y_SIZE 67

#define COLOR_BLACK 0x0000
#define COLOR_WHITE 0xFFFF
#define COLOR_BLUE  0x0000
#define COLOR_GREEN 0x0000
#define COLOR_RED   0xF800


#undef LCD_BACKLIGHT_LED

#ifdef LCD_BACKLIGHT_LED
    #define LCD_LED    p20
#endif

#define LCD_CS     p19  // P19
#define LCD_RESET  p21 //
#define LCD_A0     p27  // A0
#define LCD_WR     p22

#define LCD_DATA_PORT_L Port0 //low Nibble
#define LCD_DATA_PORT_H Port2 //high Nibble

#define LCD_DATA_PORT_MASK_L ((1<<23)|(1<<24)|(1<<25)|(1<<26)) // p15 - p22
#define LCD_DATA_PORT_MASK_H ((1<<0)|(1<<1)|(1<<2)|(1<<3))

#define DATA 1
#define COMMAND 0


void LoadPaint(void);
void LoadEEPROM(void);
void ST7626_Init(void);
void lcd_putpixel( int x, int y, int16_t color);
void lcd_clear(int16_t GroundColor);
void Write(unsigned char , int8_t ); //mode (befehl oder daten) & die Daten.
void resetdisp(void);
void LcdLoop();
extern const char Font5x7[];
extern const char Font12x16[];
extern const char AnotherFont5x7[];
void Display12x16Font(char letter, char x, char y, int16_t color);
void DisplayAnother5x7Font(char letter, char x, char y,  int16_t color);
void Display5x7Font(char letter, char x, char y, int16_t color);



#endif
