#ifndef lcd_c
#define lcd_c lcd_c
#include "lcd.h"

#ifdef LCD_BACKLIGHT_LED
DigitalOut lcd_led(LCD_LED);
#endif

DigitalOut lcd_a0(LCD_A0);
DigitalOut lcd_cs(LCD_CS);
DigitalOut lcd_wr(LCD_WR);
DigitalOut lcd_reset(LCD_RESET);

PortOut lcd_data_l(LCD_DATA_PORT_L, LCD_DATA_PORT_MASK_L);
PortOut lcd_data_h(LCD_DATA_PORT_H, LCD_DATA_PORT_MASK_H);

//////////////////////////////////////////////////////////////////////////
void LoadPaint(void) {
    Write(COMMAND, 0x31); // Ext = 1
    Write(COMMAND, 0x20); // Palette FRC1 Setup
    Write(DATA, 0x00);    // RGB Level0 Setup
    Write(DATA, 0x02);    // RGB Level1 Setup
    Write(DATA, 0x04);    // RGB Level2 Setup
    Write(DATA, 0x06);    // RGB Level3 Setup
    Write(DATA, 0x08);    // RGB Level4 Setup
    Write(DATA, 0x0A);    // RGB Level5 Setup
    Write(DATA, 0x0C);    // RGB Level6 Setup
    Write(DATA, 0x0E);    // RGB Level7 Setup
    Write(DATA, 0x10);    // RGB Level8 Setup
    Write(DATA, 0x12);    // RGB Level9 Setup
    Write(DATA, 0x14);    // RGB Level10 Setup
    Write(DATA, 0x16);    // RGB Level11 Setup
    Write(DATA, 0x18);    // RGB Level12 Setup
    Write(DATA, 0x1A);    // RGB Level13 Setup
    Write(DATA, 0x1C);    // RGB Level14 Setup
    Write(DATA, 0x1E);    // RGB Level15 Setup

    Write(COMMAND, 0x21); // Palette FRC2 Setup
    Write(DATA, 0x00);    // RGB Level0 Setup
    Write(DATA, 0x02);    // RGB Level1 Setup
    Write(DATA, 0x04);    // RGB Level2 Setup
    Write(DATA, 0x06);    // RGB Level3 Setup
    Write(DATA, 0x08);    // RGB Level4 Setup
    Write(DATA, 0x0A);    // RGB Level5 Setup
    Write(DATA, 0x0C);    // RGB Level6 Setup
    Write(DATA, 0x0E);    // RGB Level7 Setup
    Write(DATA, 0x10);    // RGB Level8 Setup
    Write(DATA, 0x12);    // RGB Level9 Setup
    Write(DATA, 0x14);    // RGB Level10 Setup
    Write(DATA, 0x16);    // RGB Level11 Setup
    Write(DATA, 0x18);    // RGB Level12 Setup
    Write(DATA, 0x1A);    // RGB Level13 Setup
    Write(DATA, 0x1C);    // RGB Level14 Setup
    Write(DATA, 0x1E);    // RGB Level15 Setup

    Write(COMMAND, 0x22); // Palette FRC3 Setup
    Write(DATA, 0x00);    // RGB Level0 Setup
    Write(DATA, 0x02);    // RGB Level1 Setup
    Write(DATA, 0x04);    // RGB Level2 Setup
    Write(DATA, 0x06);    // RGB Level3 Setup
    Write(DATA, 0x08);    // RGB Level4 Setup
    Write(DATA, 0x0A);    // RGB Level5 Setup
    Write(DATA, 0x0C);    // RGB Level6 Setup
    Write(DATA, 0x0E);    // RGB Level7 Setup
    Write(DATA, 0x10);    // RGB Level8 Setup
    Write(DATA, 0x12);    // RGB Level9 Setup
    Write(DATA, 0x14);    // RGB Level10 Setup
    Write(DATA, 0x16);    // RGB Level11 Setup
    Write(DATA, 0x18);    // RGB Level12 Setup
    Write(DATA, 0x1A);    // RGB Level13 Setup
    Write(DATA, 0x1C);    // RGB Level14 Setup
    Write(DATA, 0x1E);    // RGB Level15 Setup

    Write(COMMAND, 0x23); // Palette FRC4 Setup
    Write(DATA, 0x00);    // RGB Level0 Setup
    Write(DATA, 0x02);    // RGB Level1 Setup
    Write(DATA, 0x04);    // RGB Level2 Setup
    Write(DATA, 0x06);    // RGB Level3 Setup
    Write(DATA, 0x08);    // RGB Level4 Setup
    Write(DATA, 0x0A);    // RGB Level5 Setup
    Write(DATA, 0x0C);    // RGB Level6 Setup
    Write(DATA, 0x0E);    // RGB Level7 Setup
    Write(DATA, 0x10);    // RGB Level8 Setup
    Write(DATA, 0x12);    // RGB Level9 Setup
    Write(DATA, 0x14);    // RGB Level10 Setup
    Write(DATA, 0x16);    // RGB Level11 Setup
    Write(DATA, 0x18);    // RGB Level12 Setup
    Write(DATA, 0x1A);    // RGB Level13 Setup
    Write(DATA, 0x1C);    // RGB Level14 Setup
    Write(DATA, 0x1E);    // RGB Level15 Setup
    Write(COMMAND, 0x30); // Ext = 0
}

void LoadEEPROM(void) {
    Write(COMMAND, 0x31); // Ext = 1
    Write(COMMAND, 0xcd); // Enable EEPROM
    Write(DATA, 0x00);    //
    wait_ms(50);            // Delay 50ms
    Write(COMMAND, 0xfd); // Load EEPROM
    wait_ms(50);            // Delay 50ms
    Write(COMMAND, 0xcc); // Disable EEPROM
    Write(COMMAND, 0x30); // Ext = 0
}

void ST7626_Init(void) {
    lcd_cs = 1;
    /*    lcd_reset = 0;
        wait_ms(10);
        lcd_reset = 1;
        wait_ms(50);*/
    resetdisp();

    Write(COMMAND, 0x30); // Ext = 0
    Write(COMMAND, 0x04); // Sleep In/Out Preparation
    Write(DATA, 0x3e);    // Sleep In/Out Sequencing
    Write(COMMAND, 0x31); // Ext = 1
    Write(COMMAND, 0xf4); // Internal Initialize Preparation
    Write(DATA, 0x58);    // Internal Initialize Sequencing
    Write(COMMAND, 0x30); // Ext = 0
    Write(COMMAND, 0x94); // Sleep Out
    Write(COMMAND, 0xd1); // Internal OSC on
    Write(COMMAND, 0xca); // Display Control
    Write(DATA, 0x00);    // CL divisions Ratio
    Write(DATA, 0x10);    // Duty Setting (= 68)
    Write(DATA, 0x00);    // N-Line Inverse-set value
    Write(COMMAND, 0x31); // Ext = 1
    Write(COMMAND, 0x32); // Analog Setting
    Write(DATA, 0x00);    // OSC Freqency adjustment
    Write(DATA, 0x02);    // Booster Efficiency Setting = Level 3
    Write(DATA, 0x03);    // Bias Setting (=1/9)
    Write(DATA, 0x04);    // Booster X 5
    Write(COMMAND, 0x30); // Ext = 0
    Write(COMMAND, 0x81); // Electronic Volume Control
    Write(DATA, 0x1d);    // EV:Vop[5:0]_6bit //previously Write(DATA,0x2D);
    Write(DATA, 0x02);    // EV:Vop[8:6]_3bit
    // Vop is 10.52V under this condition for example
    Write( COMMAND, 0x20); // Power Control
    Write( DATA, 0x0b);    // B/F/R = On/On/On
    wait_ms(50);           // Delay 50ms
    LoadEEPROM();           // Load EEPROM (refer page 68)
    LoadPaint();            // Load Gamma Table Parameter (refer page 64)
    Write(COMMAND, 0x30); // Ext = 0
    Write(COMMAND, 0xa7); // Inverse Display
    Write(COMMAND, 0xbb); // Com Scan Direction
    Write(DATA, 0x01);   // 0~33 / 67~34
    Write(COMMAND, 0xbc); // Data Scan Direction
    Write(DATA, 0x00);    // Page / Column Address Setting
    Write(DATA, 0x00);    // RGB arrangement (0:RGB 1:BGR)
    Write(DATA, 0x01);    // Gray-scale setup ( 64-gray: 01H)
    Write(COMMAND, 0x75); // Page address set
    Write(DATA, 0x00);    // From page address 0
    Write(DATA, 0x43);    // to page address 67
    Write(COMMAND, 0x15); // Column address set
    Write(DATA, 0x00);    // From column address 0
    Write(DATA, 0x5f);    // to column address 97
    Write(COMMAND, 0xaf); // Display On
    Write(COMMAND, 0x30); // Ext = 0
#ifdef LCD_BACKLIGHT_LED
    lcd_led = 1;
#endif
}


void lcd_putpixel( int x, int y, int16_t color) {
    Write(COMMAND, 0x30);                    // Ext = 0
    Write(COMMAND, 0x15);                    // Column address set
    Write(DATA, x);                          // From column address 0 to 97
    Write(DATA, x+1 );
    Write(COMMAND, 0x75);                    // Page address set
    Write(DATA, y);                          // From page address 0 to 67
    Write(DATA, y+1);
    Write(COMMAND, 0x5c);                     // Entry Memory Write Mode

    Write(DATA, (int8_t) (color>>8));
    Write(DATA, (int8_t) (color));

}




void lcd_clear(int16_t GroundColor) {
    unsigned char i, j;
    Write(COMMAND, 0x30);                    // Ext = 0
    Write(COMMAND, 0x15);                    // Column address set
    Write(DATA, 0);                          // From column address 0 to 97
    Write(DATA, 97 );
    Write(COMMAND, 0x75);                    // Page address set
    Write(DATA, 0);                          // From page address 0 to 67
    Write(DATA, 67);
    Write(COMMAND, 0x5c);                     // Entry Memory Write Mode


    for (j = 0; j < 68 ; j++) {
        for (i = 0 ; i < 98 ; i++) {
            Write(DATA, (int8_t) (GroundColor>>8));
            Write(DATA, (int8_t) (GroundColor));
            
        }
    }
}

void Write(unsigned char mode, int8_t data) {
    if (mode) {
        lcd_a0 = 1; // LCD_PORT_COM |= (1<<LCD_A0);//A0=1;
    } else {
        lcd_a0 = 0; //LCD_PORT_COM &= ~(1<<LCD_A0);//A0=0;
    }

    lcd_data_l = data <<  23; //low nibble
    lcd_data_h = data >> 0x04; //high nibble

    lcd_cs = 0;    //    LCD_PORT_COM &= ~(1<<LCD_CS);//CS=0;
    lcd_wr = 0;    //LCD_PORT_COM &= ~(1<<LCD_WR);//WR=0;
    wait_us(1); //FIXME: look it up in the datasheet!!!
    lcd_wr = 1;     //LCD_PORT_COM |= (1<<LCD_WR);//WR=1;
    lcd_cs = 1;    //LCD_PORT_COM |= (1<<LCD_CS);//CS=1;
    wait_us(1);
}

void resetdisp(void) {
    lcd_reset = 1;  // LCD_PORT_COM |= (1<<LCD_RESET);
    wait_us(1);
    lcd_reset = 0;  //LCD_PORT_COM &= ~(1<<LCD_RESET);
    wait_us(1);
    lcd_reset = 1;  //LCD_PORT_COM |= (1<<LCD_RESET);
    wait_us(1);
}



#endif