
#include "lcd.h"

#define BACKROUND_COLOR 0xFFFF


void Display5x7Font(char letter, char x, char y, int16_t color) {
    //Schrift erstellen auf schwarzem Hintergrund
    unsigned char i, j;
    Write(COMMAND, 0x30);                    // Ext = 0
    Write(COMMAND, 0x15);                    // Column address set
    Write(DATA, x);                          // From column address
    Write(DATA, x+4 );    //nit 5 da erste x addresse schon z&#65533;hlt
    Write(COMMAND, 0x75);                    // Page address set
    Write(DATA, y);                          // From page address
    Write(DATA, y+7);      //nit 8 , da ja die y Addresse schon z&#65533;hlt
    Write(COMMAND, 0x5c);                     // Entry Memory Write Mode

    int sign = (letter - 0x20) * 5;
    unsigned char pos = 0x01;
    for (i = 0; i < 8 ; i++) {
        for (j = 0 ; j < 5 ; j++) { //FIXME: is this  aBUUUG?????
            char pixel = Font5x7[sign+j] & pos;
            if (pixel) {
                Write(DATA, (int8_t) color>>8);
                Write(DATA, (int8_t) color);
            } else {
                Write(DATA,(int8_t) (BACKROUND_COLOR>>8));
                Write(DATA,(int8_t) (BACKROUND_COLOR));
            }
        }
        if (pos < 0x80) {
            pos = pos << 1;
        } else {
            pos = 0x01;
        }
    }
}



void DisplayAnother5x7Font(char letter, char x, char y, int16_t color) {
    //Schrift erstellen auf schwarzem Hintergrund
    unsigned char i, j;
    Write(COMMAND, 0x30);                    // Ext = 0
    Write(COMMAND, 0x15);                    // Column address set
    Write(DATA, x);                          // From column address
    Write(DATA, x+4 );    //nit 5 da erste x addresse schon z&#65533;hlt
    Write(COMMAND, 0x75);                    // Page address set
    Write(DATA, y);                          // From page address
    Write(DATA, y+7);      //nit 8 , da ja die y Addresse schon z&#65533;hlt
    Write(COMMAND, 0x5c);                     // Entry Memory Write Mode

    int sign = (letter - 0x20) * 5;
    unsigned char pos = 0x01;
    for (i = 0; i < 8 ; i++) {
        for (j = 0 ; j < 5 ; j++) {
            char pixel = AnotherFont5x7[sign+j] & pos;
            if (pixel) {
                Write(DATA, (int8_t) (color>>8));
                Write(DATA, (int8_t) (color));
            } else {
                Write(DATA,(int8_t) (BACKROUND_COLOR>>8));
                Write(DATA,(int8_t) (BACKROUND_COLOR));
            }
        }
        if (pos < 0x80) {
            pos = pos << 1;
        } else {
            pos = 0x01;
        }
    }
}



void Display12x16Font(char letter, char x, char y, int16_t color) {
    //Schrift erstellen auf schwarzem Hintergrund
    unsigned char i, j;
    Write(COMMAND, 0x30);                    // Ext = 0
    Write(COMMAND, 0x15);                    // Column address set
    Write(DATA, x);                          // From column address
    Write(DATA, x+11 );    //nit 12 da erste x addresse schon z&#65533;hlt
    Write(COMMAND, 0x75);                    // Page address set
    Write(DATA, y);                          // From page address
    Write(DATA, y+7);      //nit 16 , da ja die y Addresse schon z&#65533;hlt
    Write(COMMAND, 0x5c);                     // Entry Memory Write Mode

    int sign = (letter - 0x20) * 24;
    unsigned char pos = 0x01;
    for (i = 0; i < 8 ; i++) {
        for (j = 0 ; j < 12 ; j++) {
            char pixel = Font12x16[sign+(j*2)] & pos;
            if (pixel) {
                Write(DATA, (int8_t) (color>>8));
                Write(DATA, (int8_t) (color));
            } else {
                Write(DATA,(int8_t) (BACKROUND_COLOR>>8));
                Write(DATA,(int8_t) (BACKROUND_COLOR));
            }
        }
        if (pos < 0x80) {
            pos = pos << 1;
        } else {
            pos = 0x01;
        }
    }



    Write(COMMAND, 0x30);                    // Ext = 0
    Write(COMMAND, 0x15);                    // Column address set
    Write(DATA, x);                          // From column address
    Write(DATA, x+11 );    //nit 12 da erste x addresse schon z&#65533;hlt
    Write(COMMAND, 0x75);                    // Page address set
    Write(DATA, y+8);                          // From page address
    Write(DATA, y+15);      //nit 16 , da ja die y Addresse schon z&#65533;hlt
    Write(COMMAND, 0x5c);                     // Entry Memory Write Mode

    sign = (letter - 0x20) * 24;
    pos = 0x01;
    for (i = 0; i < 8 ; i++) {
        for (j = 0 ; j < 12 ; j++) {
            char pixel = Font12x16[sign+(j*2)+1] & pos;
            if (pixel) {
                Write(DATA, (int8_t) (color>>8));
                Write(DATA, (int8_t) (color));
            } else {
                Write(DATA,(int8_t) (BACKROUND_COLOR>>8));
                Write(DATA,(int8_t) (BACKROUND_COLOR));
            }
        }
        if (pos < 0x80) {
            pos = pos << 1;
        } else {
            pos = 0x01;
        }
    }
}
///////////////////////////////////////////////////////////////////////////


const char Font5x7[] = {
    0x00, 0x00, 0x00, 0x00, 0x00,// (space)
    0x00, 0x00, 0x5F, 0x00, 0x00,// !
    0x00, 0x07, 0x00, 0x07, 0x00,// "
    0x14, 0x7F, 0x14, 0x7F, 0x14,// #
    0x24, 0x2A, 0x7F, 0x2A, 0x12,// $
    0x23, 0x13, 0x08, 0x64, 0x62,// %
    0x36, 0x49, 0x55, 0x22, 0x50,// &
    0x00, 0x05, 0x03, 0x00, 0x00,// '
    0x00, 0x1C, 0x22, 0x41, 0x00,// (
    0x00, 0x41, 0x22, 0x1C, 0x00,// )
    0x08, 0x2A, 0x1C, 0x2A, 0x08,// *
    0x08, 0x08, 0x3E, 0x08, 0x08,// +
    0x00, 0x50, 0x30, 0x00, 0x00,// ,
    0x08, 0x08, 0x08, 0x08, 0x08,// -
    0x00, 0x60, 0x60, 0x00, 0x00,// .
    0x20, 0x10, 0x08, 0x04, 0x02,// /
    0x3E, 0x51, 0x49, 0x45, 0x3E,// 0
    0x00, 0x42, 0x7F, 0x40, 0x00,// 1
    0x42, 0x61, 0x51, 0x49, 0x46,// 2
    0x21, 0x41, 0x45, 0x4B, 0x31,// 3
    0x18, 0x14, 0x12, 0x7F, 0x10,// 4
    0x27, 0x45, 0x45, 0x45, 0x39,// 5
    0x3C, 0x4A, 0x49, 0x49, 0x30,// 6
    0x01, 0x71, 0x09, 0x05, 0x03,// 7
    0x36, 0x49, 0x49, 0x49, 0x36,// 8
    0x06, 0x49, 0x49, 0x29, 0x1E,// 9
    0x00, 0x36, 0x36, 0x00, 0x00,// :
    0x00, 0x56, 0x36, 0x00, 0x00,// ;
    0x00, 0x08, 0x14, 0x22, 0x41,// <
    0x14, 0x14, 0x14, 0x14, 0x14,// =
    0x41, 0x22, 0x14, 0x08, 0x00,// >
    0x02, 0x01, 0x51, 0x09, 0x06,// ?
    0x32, 0x49, 0x79, 0x41, 0x3E,// @
    0x7E, 0x11, 0x11, 0x11, 0x7E,// A
    0x7F, 0x49, 0x49, 0x49, 0x36,// B
    0x3E, 0x41, 0x41, 0x41, 0x22,// C
    0x7F, 0x41, 0x41, 0x22, 0x1C,// D
    0x7F, 0x49, 0x49, 0x49, 0x41,// E
    0x7F, 0x09, 0x09, 0x01, 0x01,// F
    0x3E, 0x41, 0x41, 0x51, 0x32,// G
    0x7F, 0x08, 0x08, 0x08, 0x7F,// H
    0x00, 0x41, 0x7F, 0x41, 0x00,// I
    0x20, 0x40, 0x41, 0x3F, 0x01,// J
    0x7F, 0x08, 0x14, 0x22, 0x41,// K
    0x7F, 0x40, 0x40, 0x40, 0x40,// L
    0x7F, 0x02, 0x04, 0x02, 0x7F,// M
    0x7F, 0x04, 0x08, 0x10, 0x7F,// N
    0x3E, 0x41, 0x41, 0x41, 0x3E,// O
    0x7F, 0x09, 0x09, 0x09, 0x06,// P
    0x3E, 0x41, 0x51, 0x21, 0x5E,// Q
    0x7F, 0x09, 0x19, 0x29, 0x46,// R
    0x46, 0x49, 0x49, 0x49, 0x31,// S
    0x01, 0x01, 0x7F, 0x01, 0x01,// T
    0x3F, 0x40, 0x40, 0x40, 0x3F,// U
    0x1F, 0x20, 0x40, 0x20, 0x1F,// V
    0x7F, 0x20, 0x18, 0x20, 0x7F,// W
    0x63, 0x14, 0x08, 0x14, 0x63,// X
    0x03, 0x04, 0x78, 0x04, 0x03,// Y
    0x61, 0x51, 0x49, 0x45, 0x43,// Z
    0x00, 0x00, 0x7F, 0x41, 0x41,// [
    0x02, 0x04, 0x08, 0x10, 0x20,// "\"
    0x41, 0x41, 0x7F, 0x00, 0x00,// ]
    0x04, 0x02, 0x01, 0x02, 0x04,// ^
    0x40, 0x40, 0x40, 0x40, 0x40,// _
    0x00, 0x01, 0x02, 0x04, 0x00,// `
    0x20, 0x54, 0x54, 0x54, 0x78,// a
    0x7F, 0x48, 0x44, 0x44, 0x38,// b
    0x38, 0x44, 0x44, 0x44, 0x20,// c
    0x38, 0x44, 0x44, 0x48, 0x7F,// d
    0x38, 0x54, 0x54, 0x54, 0x18,// e
    0x08, 0x7E, 0x09, 0x01, 0x02,// f
    0x08, 0x14, 0x54, 0x54, 0x3C,// g
    0x7F, 0x08, 0x04, 0x04, 0x78,// h
    0x00, 0x44, 0x7D, 0x40, 0x00,// i
    0x20, 0x40, 0x44, 0x3D, 0x00,// j
    0x00, 0x7F, 0x10, 0x28, 0x44,// k
    0x00, 0x41, 0x7F, 0x40, 0x00,// l
    0x7C, 0x04, 0x18, 0x04, 0x78,// m
    0x7C, 0x08, 0x04, 0x04, 0x78,// n
    0x38, 0x44, 0x44, 0x44, 0x38,// o
    0x7C, 0x14, 0x14, 0x14, 0x08,// p
    0x08, 0x14, 0x14, 0x18, 0x7C,// q
    0x7C, 0x08, 0x04, 0x04, 0x08,// r
    0x48, 0x54, 0x54, 0x54, 0x20,// s
    0x04, 0x3F, 0x44, 0x40, 0x20,// t
    0x3C, 0x40, 0x40, 0x20, 0x7C,// u
    0x1C, 0x20, 0x40, 0x20, 0x1C,// v
    0x3C, 0x40, 0x30, 0x40, 0x3C,// w
    0x44, 0x28, 0x10, 0x28, 0x44,// x
    0x0C, 0x50, 0x50, 0x50, 0x3C,// y
    0x44, 0x64, 0x54, 0x4C, 0x44,// z
    0x00, 0x08, 0x36, 0x41, 0x00,// {
    0x00, 0x00, 0x7F, 0x00, 0x00,// |
    0x00, 0x41, 0x36, 0x08, 0x00,// }
    0x08, 0x08, 0x2A, 0x1C, 0x08,// ->
    0x08, 0x1C, 0x2A, 0x08, 0x08 // <-
};

const char Font12x16[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // "(space)"
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x7C, 0x00, 0xFF, 0x33, 0xFF, 0x33, 0x7C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // "!"
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // """
    0x00, 0x00, 0x00, 0x02, 0x10, 0x1E, 0x90, 0x1F, 0xF0, 0x03, 0x7E, 0x02, 0x1E, 0x1E, 0x90, 0x1F, 0xF0, 0x03, 0x7E, 0x02, 0x1E, 0x00, 0x10, 0x00, // "#"
    0x00, 0x00, 0x00, 0x00, 0x78, 0x04, 0xFC, 0x0C, 0xCC, 0x0C, 0xFF, 0x3F, 0xFF, 0x3F, 0xCC, 0x0C, 0xCC, 0x0F, 0x88, 0x07, 0x00, 0x00, 0x00, 0x00, // "$"
    0x00, 0x00, 0x00, 0x30, 0x38, 0x38, 0x38, 0x1C, 0x38, 0x0E, 0x00, 0x07, 0x80, 0x03, 0xC0, 0x01, 0xE0, 0x38, 0x70, 0x38, 0x38, 0x38, 0x1C, 0x00, // "%"
    0x00, 0x00, 0x00, 0x00, 0x00, 0x1F, 0xB8, 0x3F, 0xFC, 0x31, 0xC6, 0x21, 0xE2, 0x37, 0x3E, 0x1E, 0x1C, 0x1C, 0x00, 0x36, 0x00, 0x22, 0x00, 0x00, // "&"
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x27, 0x00, 0x3F, 0x00, 0x1F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // "'"
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xF0, 0x03, 0xFC, 0x0F, 0xFE, 0x1F, 0x07, 0x38, 0x01, 0x20, 0x01, 0x20, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // "("
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x01, 0x20, 0x01, 0x20, 0x07, 0x38, 0xFE, 0x1F, 0xFC, 0x0F, 0xF0, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // ")"
    0x00, 0x00, 0x00, 0x00, 0x98, 0x0C, 0xB8, 0x0E, 0xE0, 0x03, 0xF8, 0x0F, 0xF8, 0x0F, 0xE0, 0x03, 0xB8, 0x0E, 0x98, 0x0C, 0x00, 0x00, 0x00, 0x00, // "*"
    0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0xF0, 0x0F, 0xF0, 0x0F, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, // "+"
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xB8, 0x00, 0xF8, 0x00, 0x78, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // ","
    0x00, 0x00, 0x00, 0x00, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x80, 0x01, 0x00, 0x00, 0x00, 0x00, // "-"
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x38, 0x00, 0x38, 0x00, 0x38, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // "."
    0x00, 0x00, 0x00, 0x18, 0x00, 0x1C, 0x00, 0x0E, 0x00, 0x07, 0x80, 0x03, 0xC0, 0x01, 0xE0, 0x00, 0x70, 0x00, 0x38, 0x00, 0x1C, 0x00, 0x0E, 0x00, // "/"
    0x00, 0x00, 0xF8, 0x07, 0xFE, 0x1F, 0x06, 0x1E, 0x03, 0x33, 0x83, 0x31, 0xC3, 0x30, 0x63, 0x30, 0x33, 0x30, 0x1E, 0x18, 0xFE, 0x1F, 0xF8, 0x07, // "0"
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0C, 0x30, 0x0C, 0x30, 0x0E, 0x30, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, // "1"
    0x00, 0x00, 0x1C, 0x30, 0x1E, 0x38, 0x07, 0x3C, 0x03, 0x3E, 0x03, 0x37, 0x83, 0x33, 0xC3, 0x31, 0xE3, 0x30, 0x77, 0x30, 0x3E, 0x30, 0x1C, 0x30, // "2"
    0x00, 0x00, 0x0C, 0x0C, 0x0E, 0x1C, 0x07, 0x38, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xE7, 0x39, 0x7E, 0x1F, 0x3C, 0x0E, // "3"
    0x00, 0x00, 0xC0, 0x03, 0xE0, 0x03, 0x70, 0x03, 0x38, 0x03, 0x1C, 0x03, 0x0E, 0x03, 0x07, 0x03, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x03, 0x00, 0x03, // "4"
    0x00, 0x00, 0x3F, 0x0C, 0x7F, 0x1C, 0x63, 0x38, 0x63, 0x30, 0x63, 0x30, 0x63, 0x30, 0x63, 0x30, 0x63, 0x30, 0xE3, 0x38, 0xC3, 0x1F, 0x83, 0x0F, // "5"
    0x00, 0x00, 0xC0, 0x0F, 0xF0, 0x1F, 0xF8, 0x39, 0xDC, 0x30, 0xCE, 0x30, 0xC7, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x39, 0x80, 0x1F, 0x00, 0x0F, // "6"
    0x00, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x30, 0x03, 0x3C, 0x03, 0x0F, 0xC3, 0x03, 0xF3, 0x00, 0x3F, 0x00, 0x0F, 0x00, 0x03, 0x00, // "7"
    0x00, 0x00, 0x00, 0x0F, 0xBC, 0x1F, 0xFE, 0x39, 0xE7, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xE7, 0x30, 0xFE, 0x39, 0xBC, 0x1F, 0x00, 0x0F, // "8"
    0x00, 0x00, 0x3C, 0x00, 0x7E, 0x00, 0xE7, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x38, 0xC3, 0x1C, 0xC3, 0x0E, 0xE7, 0x07, 0xFE, 0x03, 0xFC, 0x00, // "9"
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x1C, 0x70, 0x1C, 0x70, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // ":"
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x9C, 0x70, 0xFC, 0x70, 0x7C, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // ";"
    0x00, 0x00, 0x00, 0x00, 0xC0, 0x00, 0xE0, 0x01, 0xF0, 0x03, 0x38, 0x07, 0x1C, 0x0E, 0x0E, 0x1C, 0x07, 0x38, 0x03, 0x30, 0x00, 0x00, 0x00, 0x00, // "<"
    0x00, 0x00, 0x00, 0x00, 0x60, 0x06, 0x60, 0x06, 0x60, 0x06, 0x60, 0x06, 0x60, 0x06, 0x60, 0x06, 0x60, 0x06, 0x60, 0x06, 0x60, 0x06, 0x00, 0x00, // "="
    0x00, 0x00, 0x00, 0x00, 0x03, 0x30, 0x07, 0x38, 0x0E, 0x1C, 0x1C, 0x0E, 0x38, 0x07, 0xF0, 0x03, 0xE0, 0x01, 0xC0, 0x00, 0x00, 0x00, 0x00, 0x00, // ">"
    0x00, 0x00, 0x1C, 0x00, 0x1E, 0x00, 0x07, 0x00, 0x03, 0x00, 0x83, 0x37, 0xC3, 0x37, 0xE3, 0x00, 0x77, 0x00, 0x3E, 0x00, 0x1C, 0x00, 0x00, 0x00, // "?"
    0x00, 0x00, 0xF8, 0x07, 0xFE, 0x1F, 0x07, 0x18, 0xF3, 0x33, 0xFB, 0x37, 0x1B, 0x36, 0xFB, 0x37, 0xFB, 0x37, 0x07, 0x36, 0xFE, 0x03, 0xF8, 0x01, // "@"
    0x00, 0x00, 0x00, 0x38, 0x00, 0x3F, 0xE0, 0x07, 0xFC, 0x06, 0x1F, 0x06, 0x1F, 0x06, 0xFC, 0x06, 0xE0, 0x07, 0x00, 0x3F, 0x00, 0x38, 0x00, 0x00, // "A"
    0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xE7, 0x30, 0xFE, 0x39, 0xBC, 0x1F, 0x00, 0x0F, 0x00, 0x00, // "B"
    0x00, 0x00, 0xF0, 0x03, 0xFC, 0x0F, 0x0E, 0x1C, 0x07, 0x38, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x07, 0x38, 0x0E, 0x1C, 0x0C, 0x0C, 0x00, 0x00, // "C"
    0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x07, 0x38, 0x0E, 0x1C, 0xFC, 0x0F, 0xF0, 0x03, 0x00, 0x00, // "D"
    0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0x03, 0x30, 0x03, 0x30, 0x00, 0x00, // "E"
    0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0xC3, 0x00, 0xC3, 0x00, 0xC3, 0x00, 0xC3, 0x00, 0xC3, 0x00, 0xC3, 0x00, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, // "F"
    0x00, 0x00, 0xF0, 0x03, 0xFC, 0x0F, 0x0E, 0x1C, 0x07, 0x38, 0x03, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC7, 0x3F, 0xC6, 0x3F, 0x00, 0x00, // "G"
    0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00, // "H"
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x30, 0x03, 0x30, 0xFF, 0x3F, 0xFF, 0x3F, 0x03, 0x30, 0x03, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // "I"
    0x00, 0x00, 0x00, 0x0E, 0x00, 0x1E, 0x00, 0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x38, 0xFF, 0x1F, 0xFF, 0x07, 0x00, 0x00, // "J"
    0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0xC0, 0x00, 0xE0, 0x01, 0xF0, 0x03, 0x38, 0x07, 0x1C, 0x0E, 0x0E, 0x1C, 0x07, 0x38, 0x03, 0x30, 0x00, 0x00, // "K"
    0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, // "L"
    0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x1E, 0x00, 0x78, 0x00, 0xE0, 0x01, 0xE0, 0x01, 0x78, 0x00, 0x1E, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00, // "M"
    0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x0E, 0x00, 0x38, 0x00, 0xF0, 0x00, 0xC0, 0x03, 0x00, 0x07, 0x00, 0x1C, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00, // "N"
    0x00, 0x00, 0xF0, 0x03, 0xFC, 0x0F, 0x0E, 0x1C, 0x07, 0x38, 0x03, 0x30, 0x03, 0x30, 0x07, 0x38, 0x0E, 0x1C, 0xFC, 0x0F, 0xF0, 0x03, 0x00, 0x00, // "O"
    0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x83, 0x01, 0x83, 0x01, 0x83, 0x01, 0x83, 0x01, 0x83, 0x01, 0xC7, 0x01, 0xFE, 0x00, 0x7C, 0x00, 0x00, 0x00, // "P"
    0x00, 0x00, 0xF0, 0x03, 0xFC, 0x0F, 0x0E, 0x1C, 0x07, 0x38, 0x03, 0x30, 0x03, 0x36, 0x07, 0x3E, 0x0E, 0x1C, 0xFC, 0x3F, 0xF0, 0x33, 0x00, 0x00, // "Q"
    0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x83, 0x01, 0x83, 0x01, 0x83, 0x03, 0x83, 0x07, 0x83, 0x0F, 0xC7, 0x1D, 0xFE, 0x38, 0x7C, 0x30, 0x00, 0x00, // "R"
    0x00, 0x00, 0x3C, 0x0C, 0x7E, 0x1C, 0xE7, 0x38, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC3, 0x30, 0xC7, 0x39, 0x8E, 0x1F, 0x0C, 0x0F, 0x00, 0x00, // "S"
    0x00, 0x00, 0x00, 0x00, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x03, 0x00, 0x03, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, // "T"
    0x00, 0x00, 0xFF, 0x07, 0xFF, 0x1F, 0x00, 0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x38, 0xFF, 0x1F, 0xFF, 0x07, 0x00, 0x00, // "U"
    0x00, 0x00, 0x07, 0x00, 0x3F, 0x00, 0xF8, 0x01, 0xC0, 0x0F, 0x00, 0x3E, 0x00, 0x3E, 0xC0, 0x0F, 0xF8, 0x01, 0x3F, 0x00, 0x07, 0x00, 0x00, 0x00, // "V"
    0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x1C, 0x00, 0x06, 0x80, 0x03, 0x80, 0x03, 0x00, 0x06, 0x00, 0x1C, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00, // "W"
    0x00, 0x00, 0x03, 0x30, 0x0F, 0x3C, 0x1C, 0x0E, 0x30, 0x03, 0xE0, 0x01, 0xE0, 0x01, 0x30, 0x03, 0x1C, 0x0E, 0x0F, 0x3C, 0x03, 0x30, 0x00, 0x00, // "X"
    0x00, 0x00, 0x03, 0x00, 0x0F, 0x00, 0x3C, 0x00, 0xF0, 0x00, 0xC0, 0x3F, 0xC0, 0x3F, 0xF0, 0x00, 0x3C, 0x00, 0x0F, 0x00, 0x03, 0x00, 0x00, 0x00, // "Y"
    0x00, 0x00, 0x03, 0x30, 0x03, 0x3C, 0x03, 0x3E, 0x03, 0x33, 0xC3, 0x31, 0xE3, 0x30, 0x33, 0x30, 0x1F, 0x30, 0x0F, 0x30, 0x03, 0x30, 0x00, 0x00, // "Z"
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // "["
    0x00, 0x00, 0x0E, 0x00, 0x1C, 0x00, 0x38, 0x00, 0x70, 0x00, 0xE0, 0x00, 0xC0, 0x01, 0x80, 0x03, 0x00, 0x07, 0x00, 0x0E, 0x00, 0x1C, 0x00, 0x18, // "\"
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0x03, 0x30, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // "]"
    0x00, 0x00, 0x60, 0x00, 0x70, 0x00, 0x38, 0x00, 0x1C, 0x00, 0x0E, 0x00, 0x07, 0x00, 0x0E, 0x00, 0x1C, 0x00, 0x38, 0x00, 0x70, 0x00, 0x60, 0x00, // "^"
    0x00, 0x00, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, // "_"
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x3E, 0x00, 0x7E, 0x00, 0x4E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // "`"
    0x00, 0x00, 0x00, 0x1C, 0x40, 0x3E, 0x60, 0x33, 0x60, 0x33, 0x60, 0x33, 0x60, 0x33, 0x60, 0x33, 0x60, 0x33, 0xE0, 0x3F, 0xC0, 0x3F, 0x00, 0x00, // "a"
    0x00, 0x00, 0xFF, 0x7F, 0xFF, 0x7F, 0x80, 0x61, 0xC0, 0x60, 0xC0, 0x60, 0xC0, 0x60, 0xC0, 0x60, 0xC0, 0x71, 0x80, 0x3F, 0x00, 0x1F, 0x00, 0x00, // "b"
    0x00, 0x00, 0x80, 0x0F, 0xC0, 0x1F, 0xE0, 0x38, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0xC0, 0x18, 0x80, 0x08, 0x00, 0x00, // "c"
    0x00, 0x00, 0x80, 0x0F, 0xC0, 0x1F, 0xE0, 0x38, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0xE0, 0x30, 0xC0, 0x30, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00, // "d"
    0x00, 0x00, 0x80, 0x0F, 0xC0, 0x1F, 0xE0, 0x3B, 0x60, 0x33, 0x60, 0x33, 0x60, 0x33, 0x60, 0x33, 0x60, 0x33, 0xC0, 0x13, 0x80, 0x01, 0x00, 0x00, // "e"
    0x00, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xFC, 0x3F, 0xFE, 0x3F, 0xC7, 0x00, 0xC3, 0x00, 0xC3, 0x00, 0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // "f"
    0x00, 0x00, 0x80, 0x03, 0xC0, 0xC7, 0xE0, 0xCE, 0x60, 0xCC, 0x60, 0xCC, 0x60, 0xCC, 0x60, 0xCC, 0x60, 0xE6, 0xE0, 0x7F, 0xE0, 0x3F, 0x00, 0x00, // "g"
    0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x80, 0x01, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x00, 0xC0, 0x01, 0x80, 0x3F, 0x00, 0x3F, 0x00, 0x00, 0x00, 0x00, // "h"
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x60, 0x30, 0xEC, 0x3F, 0xEC, 0x3F, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // "i"
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0xE0, 0x00, 0xC0, 0x60, 0xC0, 0xEC, 0xFF, 0xEC, 0x7F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // "j"
    0x00, 0x00, 0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x03, 0x80, 0x07, 0xC0, 0x0F, 0xE0, 0x1C, 0x70, 0x38, 0x30, 0x30, 0x00, 0x00, 0x00, 0x00, // "k"
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x30, 0x03, 0x30, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // "l"
    0x00, 0x00, 0xE0, 0x3F, 0xC0, 0x3F, 0xE0, 0x00, 0xE0, 0x00, 0xC0, 0x3F, 0xC0, 0x3F, 0xE0, 0x00, 0xE0, 0x00, 0xC0, 0x3F, 0x80, 0x3F, 0x00, 0x00, // "m"
    0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0xE0, 0x3F, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0xE0, 0x00, 0xC0, 0x3F, 0x80, 0x3F, 0x00, 0x00, // "n"
    0x00, 0x00, 0x80, 0x0F, 0xC0, 0x1F, 0xE0, 0x38, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0xE0, 0x38, 0xC0, 0x1F, 0x80, 0x0F, 0x00, 0x00, // "o"
    0x00, 0x00, 0xE0, 0xFF, 0xE0, 0xFF, 0x60, 0x0C, 0x60, 0x18, 0x60, 0x18, 0x60, 0x18, 0x60, 0x18, 0xE0, 0x1C, 0xC0, 0x0F, 0x80, 0x07, 0x00, 0x00, // "p"
    0x00, 0x00, 0x80, 0x07, 0xC0, 0x0F, 0xE0, 0x1C, 0x60, 0x18, 0x60, 0x18, 0x60, 0x18, 0x60, 0x18, 0x60, 0x0C, 0xE0, 0xFF, 0xE0, 0xFF, 0x00, 0x00, // "q"
    0x00, 0x00, 0x00, 0x00, 0xE0, 0x3F, 0xE0, 0x3F, 0xC0, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0x60, 0x00, 0xE0, 0x00, 0xC0, 0x00, 0x00, 0x00, // "r"
    0x00, 0x00, 0xC0, 0x11, 0xE0, 0x33, 0x60, 0x33, 0x60, 0x33, 0x60, 0x33, 0x60, 0x33, 0x60, 0x3F, 0x40, 0x1E, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // "s"
    0x00, 0x00, 0x60, 0x00, 0x60, 0x00, 0xFE, 0x1F, 0xFE, 0x3F, 0x60, 0x30, 0x60, 0x30, 0x60, 0x30, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // "t"
    0x00, 0x00, 0xE0, 0x0F, 0xE0, 0x1F, 0x00, 0x38, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x30, 0x00, 0x18, 0xE0, 0x3F, 0xE0, 0x3F, 0x00, 0x00, // "u"
    0x00, 0x00, 0x60, 0x00, 0xE0, 0x01, 0x80, 0x07, 0x00, 0x1E, 0x00, 0x38, 0x00, 0x38, 0x00, 0x1E, 0x80, 0x07, 0xE0, 0x01, 0x60, 0x00, 0x00, 0x00, // "v"
    0x00, 0x00, 0xE0, 0x07, 0xE0, 0x1F, 0x00, 0x38, 0x00, 0x1C, 0xE0, 0x0F, 0xE0, 0x0F, 0x00, 0x1C, 0x00, 0x38, 0xE0, 0x1F, 0xE0, 0x07, 0x00, 0x00, // "w"
    0x00, 0x00, 0x60, 0x30, 0xE0, 0x38, 0xC0, 0x1D, 0x80, 0x0F, 0x00, 0x07, 0x80, 0x0F, 0xC0, 0x1D, 0xE0, 0x38, 0x60, 0x30, 0x00, 0x00, 0x00, 0x00, // "x"
    0x00, 0x00, 0x00, 0x00, 0x60, 0x00, 0xE0, 0x81, 0x80, 0xE7, 0x00, 0x7E, 0x00, 0x1E, 0x80, 0x07, 0xE0, 0x01, 0x60, 0x00, 0x00, 0x00, 0x00, 0x00, // "y"
    0x00, 0x00, 0x60, 0x30, 0x60, 0x38, 0x60, 0x3C, 0x60, 0x36, 0x60, 0x33, 0xE0, 0x31, 0xE0, 0x30, 0x60, 0x30, 0x20, 0x30, 0x00, 0x00, 0x00, 0x00, // "z"
    0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0xC0, 0x01, 0xFC, 0x1F, 0x7E, 0x3F, 0x07, 0x70, 0x03, 0x60, 0x03, 0x60, 0x03, 0x60, 0x00, 0x00, 0x00, 0x00, // "{"
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xFF, 0x3F, 0xFF, 0x3F, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, // "|"
    0x00, 0x00, 0x00, 0x00, 0x03, 0x60, 0x03, 0x60, 0x03, 0x60, 0x07, 0x70, 0x7E, 0x3F, 0xFC, 0x1F, 0xC0, 0x01, 0x80, 0x00, 0x00, 0x00, 0x00, 0x00, // "}"
    0x00, 0x00, 0x10, 0x00, 0x18, 0x00, 0x0C, 0x00, 0x04, 0x00, 0x0C, 0x00, 0x18, 0x00, 0x10, 0x00, 0x18, 0x00, 0x0C, 0x00, 0x04, 0x00, 0x00, 0x00, // "~"
    0x00, 0x00, 0x00, 0x0F, 0x80, 0x0F, 0xC0, 0x0C, 0x60, 0x0C, 0x30, 0x0C, 0x30, 0x0C, 0x60, 0x0C, 0xC0, 0x0C, 0x80, 0x0F, 0x00, 0x0F, 0x00, 0x00  // "ein Haus :)"
};


const char AnotherFont5x7[510] = {
    0x00, 0x00, 0x00, 0x00, 0x00,            // Code for char
    0x00, 0x00, 0x00, 0x00, 0x5F,            // Code for char !
    0x00, 0x00, 0x03, 0x00, 0x03,            // Code for char "
    0x24, 0x7E, 0x24, 0x7E, 0x24,            // Code for char #
    0x12, 0x25, 0x7F, 0x29, 0x12,            // Code for char $
    0x03, 0x33, 0x0C, 0x33, 0x30,            // Code for char %
    0x10, 0x2A, 0x25, 0x7A, 0x20,            // Code for char &
    0x00, 0x00, 0x00, 0x00, 0x03,            // Code for char '
    0x00, 0x00, 0x1C, 0x22, 0x41,            // Code for char (
    0x00, 0x00, 0x41, 0x22, 0x1C,            // Code for char )
    0x04, 0x1E, 0x0C, 0x1E, 0x04,            // Code for char *
    0x08, 0x08, 0x3E, 0x08, 0x08,            // Code for char +
    0x00, 0x00, 0x00, 0x40, 0x20,            // Code for char ,
    0x08, 0x08, 0x08, 0x08, 0x08,            // Code for char -
    0x00, 0x00, 0x00, 0x00, 0x20,            // Code for char .
    0x00, 0x00, 0x30, 0x0C, 0x03,            // Code for char /
    0x1E, 0x31, 0x2D, 0x23, 0x1E,            // Code for char 0
    0x00, 0x00, 0x02, 0x01, 0x3F,            // Code for char 1
    0x22, 0x31, 0x29, 0x25, 0x22,            // Code for char 2
    0x00, 0x21, 0x25, 0x25, 0x1E,            // Code for char 3
    0x18, 0x14, 0x12, 0x3F, 0x10,            // Code for char 4
    0x17, 0x25, 0x25, 0x25, 0x19,            // Code for char 5
    0x1E, 0x25, 0x25, 0x25, 0x18,            // Code for char 6
    0x01, 0x31, 0x09, 0x05, 0x03,            // Code for char 7
    0x1A, 0x25, 0x25, 0x25, 0x1A,            // Code for char 8
    0x06, 0x29, 0x29, 0x29, 0x1E,            // Code for char 9
    0x00, 0x00, 0x00, 0x00, 0x28,            // Code for char :
    0x00, 0x00, 0x00, 0x40, 0x28,            // Code for char ;
    0x00, 0x00, 0x08, 0x14, 0x22,            // Code for char <
    0x14, 0x14, 0x14, 0x14, 0x14,            // Code for char =
    0x00, 0x00, 0x22, 0x14, 0x08,            // Code for char >
    0x02, 0x01, 0x51, 0x09, 0x06,            // Code for char ?
    0x1C, 0x2A, 0x36, 0x36, 0x2C,            // Code for char @
    0x3C, 0x0A, 0x09, 0x0A, 0x3C,            // Code for char A
    0x3F, 0x25, 0x25, 0x25, 0x1A,            // Code for char B
    0x00, 0x1E, 0x21, 0x21, 0x21,            // Code for char C
    0x00, 0x3F, 0x21, 0x21, 0x1E,            // Code for char D
    0x00, 0x3F, 0x25, 0x25, 0x21,            // Code for char E
    0x00, 0x3F, 0x05, 0x05, 0x01,            // Code for char F
    0x00, 0x1E, 0x21, 0x29, 0x19,            // Code for char G
    0x00, 0x3F, 0x04, 0x04, 0x3F,            // Code for char H
    0x00, 0x00, 0x21, 0x3F, 0x21,            // Code for char I
    0x00, 0x01, 0x41, 0x41, 0x3F,            // Code for char J
    0x00, 0x3F, 0x0C, 0x12, 0x21,            // Code for char K
    0x00, 0x00, 0x3F, 0x20, 0x20,            // Code for char L
    0x3F, 0x02, 0x04, 0x02, 0x3F,            // Code for char M
    0x3F, 0x03, 0x0C, 0x30, 0x3F,            // Code for char N
    0x1E, 0x21, 0x21, 0x21, 0x1E,            // Code for char O
    0x00, 0x3F, 0x05, 0x05, 0x02,            // Code for char P
    0x1E, 0x21, 0x29, 0x31, 0x3E,            // Code for char Q
    0x00, 0x3F, 0x0D, 0x15, 0x22,            // Code for char R
    0x00, 0x16, 0x25, 0x29, 0x1A,            // Code for char S
    0x01, 0x01, 0x3F, 0x01, 0x01,            // Code for char T
    0x1F, 0x20, 0x20, 0x20, 0x1F,            // Code for char U
    0x0F, 0x10, 0x20, 0x10, 0x0F,            // Code for char V
    0x3F, 0x10, 0x08, 0x10, 0x3F,            // Code for char W
    0x21, 0x12, 0x0C, 0x12, 0x21,            // Code for char X
    0x03, 0x34, 0x18, 0x04, 0x03,            // Code for char Y
    0x21, 0x31, 0x29, 0x25, 0x23,            // Code for char Z
    0x00, 0x00, 0x00, 0x7F, 0x41,            // Code for char [
    0x00, 0x00, 0x03, 0x0C, 0x30,            // Code for char BackSlash
    0x00, 0x00, 0x00, 0x41, 0x7F,            // Code for char ]
    0x00, 0x00, 0x02, 0x01, 0x02,            // Code for char ^
    0x00, 0x20, 0x20, 0x20, 0x20,            // Code for char _
    0x00, 0x00, 0x00, 0x01, 0x02,            // Code for char `
    0x00, 0x18, 0x24, 0x24, 0x3C,            // Code for char a
    0x00, 0x3F, 0x24, 0x24, 0x18,            // Code for char b
    0x00, 0x00, 0x18, 0x24, 0x24,            // Code for char c
    0x00, 0x18, 0x24, 0x24, 0x3F,            // Code for char d
    0x00, 0x18, 0x2C, 0x2C, 0x28,            // Code for char e
    0x00, 0x00, 0x08, 0x7C, 0x0A,            // Code for char f
    0x00, 0x00, 0x08, 0x54, 0x3C,            // Code for char g
    0x00, 0x3F, 0x08, 0x04, 0x38,            // Code for char h
    0x00, 0x00, 0x00, 0x08, 0x3A,            // Code for char i
    0x00, 0x00, 0x00, 0x48, 0x3A,            // Code for char j
    0x00, 0x3F, 0x08, 0x14, 0x20,            // Code for char k
    0x00, 0x00, 0x00, 0x3F, 0x20,            // Code for char l
    0x3C, 0x04, 0x38, 0x04, 0x38,            // Code for char m
    0x00, 0x3C, 0x04, 0x04, 0x38,            // Code for char n
    0x00, 0x18, 0x24, 0x24, 0x18,            // Code for char o
    0x00, 0x78, 0x24, 0x24, 0x18,            // Code for char p
    0x00, 0x18, 0x24, 0x24, 0x78,            // Code for char q
    0x00, 0x00, 0x3C, 0x08, 0x04,            // Code for char r
    0x00, 0x00, 0x2C, 0x2C, 0x34,            // Code for char s
    0x00, 0x00, 0x04, 0x1E, 0x24,            // Code for char t
    0x00, 0x1C, 0x20, 0x20, 0x3C,            // Code for char u
    0x00, 0x00, 0x0C, 0x30, 0x0C,            // Code for char v
    0x1C, 0x20, 0x38, 0x20, 0x1C,            // Code for char w
    0x00, 0x00, 0x24, 0x18, 0x24,            // Code for char x
    0x00, 0x00, 0x4C, 0x30, 0x0C,            // Code for char y
    0x00, 0x24, 0x34, 0x2C, 0x24,            // Code for char z
    0x00, 0x00, 0x08, 0x36, 0x41,            // Code for char {
    0x00, 0x00, 0x00, 0x00, 0x7F,            // Code for char |
    0x00, 0x00, 0x41, 0x36, 0x08,            // Code for char }
    0x08, 0x04, 0x08, 0x10, 0x08,            // Code for char ~
    0x00, 0x19, 0x24, 0x24, 0x3D,            // Code for char ?
    0x00, 0x1A, 0x24, 0x24, 0x1A,            // Code for char ?
    0x00, 0x1D, 0x20, 0x20, 0x3D,            // Code for char ?
    0x3D, 0x0A, 0x09, 0x0A, 0x3D,            // Code for char A
    0x1D, 0x22, 0x22, 0x22, 0x1D,            // Code for char ?
    0x1D, 0x20, 0x20, 0x20, 0x1D,            // Code for char ?
    0x00, 0x7E, 0x25, 0x2A, 0x10             // Code for char ?
};
