#include "mbed.h"
#include "TextLCD.h"
#include "EthernetNetIf.h"
#include "HttpClient.h"

void free_member(struct member *p);
void print_member(struct member *p);
struct member *add_member(char *name, int id, struct member *head);
unsigned int readCard();
struct member * search_id(struct member *p,unsigned int id);
struct member *create_member(void);
void LED_Bright(int led_num);
void LED_KnightRider();

using namespace std;

EthernetNetIf eth;
HttpClient http;

LocalFileSystem local("local");

Serial pc(USBTX, USBRX); // tx, rx
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);

Serial device(p13, p14); // tx, rx
InterruptIn button(p17);
DigitalIn irq(p19);
//DigitalOut rst(p20);

//TextLCD lcd(p15, p9, p16, p8, p11, p7, p10); // rs, rw, e, d0, d1, d2, d3
TextLCD lcd(p5, p6, p7, p8, p9, p10); // rs, rw, e, d0, d1, d2, d3

const char user[] = "your accout";
const char pass[] = "yourt password";
const char login_msg[] = " is login now.";
const char logout_msg[] = " is logout now.";
const char url[]  = "http://twitter.com/statuses/update.xml";
const char ntp_server[]  = "http://ntp-a1.nict.go.jp/cgi-bin/ntp";
bool card_flag=false;

struct member {
    char name[100];
    unsigned int id;
    bool enter;
    struct member *next;
};

void cardIRQ() {
    card_flag=true;
}


int main() {
    device.baud(19200);
    pc.baud(9600);
    printf("Init\n");
    lcd.printf("Init\n");
    char sendmsg[255];
    char buf[40];
    member *p=NULL;
    member *head=NULL;
    time_t seconds = time(NULL);
    HttpClient twitter;
    char *e;
    char name[100];
    unsigned int id;

    HttpMap msg;

    //connect Ethernet
    printf("\r\nSetting up...\r\n");
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    printf("\r\nSetup OK\r\n");

    twitter.basicAuth(user, pass); //We use basic authentication, replace with you accoun

    //read member
    pc.printf("Opening File...\n"); // Drive should be marked as removed
    FILE *fp = fopen("/local/member.txt", "r");

    while (fscanf( fp, "%[^,],%d\n",name, &id) != EOF ) {
        head = add_member(name,id, head);
    }
    fclose(fp);
    pc.printf("Opened.\n");

    // Start RTC
    lcd.printf("RTC setting...\n");
    HttpText txt;

    http.get(ntp_server, &txt);
    int start_body=strstr(txt.gets(),"<BODY>")-txt.gets()+7;
    int end_body = strstr(txt.gets(),"</BODY>")-txt.gets()-1;
    strncpy(buf, txt.gets()+start_body, end_body-start_body);


    //printf("<%s>\n",txt.gets());
    //printf("%lu\n",strtoul(buf,&e,10));
    seconds = strtoul(buf,&e,10)-2208988800UL+32400;
    set_time(seconds);

    button.rise(&cardIRQ);
    while (1) {
        seconds = time(NULL);
        strftime(buf,sizeof(buf),"%Y/%m/%d %a\n%H:%M:%S  Ready!", localtime(&seconds));
        printf("%s\n", buf);
        lcd.printf("%s", buf);
        wait(0.3);

        if (card_flag) {
            lcd.cls();
            strcpy(sendmsg,"");

            id= readCard();
            pc.printf("id=%u\n",id);
            p = search_id(head,id);//checkID

            if (p!=NULL) {//list has same ID
                pc.printf("%s\n",p->name);

                lcd.locate(0,0);
                lcd.printf("%s",p->name);
                lcd.locate(0,1);
                lcd.printf("id=%u",p->id);

                strcat(sendmsg,p->name);
                seconds = time(NULL);
                strftime(buf,sizeof(buf), " (%Y/%m/%d %a %H:%M:%S)", localtime(&seconds));

                if (p->enter) {
                    strcat(sendmsg,logout_msg);
                    strcat(sendmsg,buf);
                    pc.printf("%s\n",sendmsg);
                    msg["status"] = sendmsg;
                    twitter.post(url, msg, NULL);

                    p->enter=false;
                } else {
                    strcat(sendmsg,login_msg);
                    strcat(sendmsg,buf);
                    pc.printf("%s\n",sendmsg);
                    msg["status"] = sendmsg;
                    twitter.post(url, msg, NULL);

                    p->enter=true;
                }
                LED_KnightRider();

                card_flag=false;
                lcd.cls();
            } else {
                lcd.locate(0,0);
                lcd.printf("You are'nt member");
                lcd.locate(0,1);
                lcd.printf("id=%u",id);
                wait(1);
                card_flag=false;
                lcd.cls();
            }

        }

    }
}

void LED_KnightRider() {
    LED_Bright(1);
    wait(0.05);
    LED_Bright(2);
    wait(0.05);
    LED_Bright(3);
    wait(0.05);
    LED_Bright(4);
    wait(0.05);
    LED_Bright(3);
    wait(0.05);
    LED_Bright(2);
    wait(0.05);
    LED_Bright(1);
    wait(0.05);
    LED_Bright(0);
    wait(0.05);
    LED_Bright(1);
    wait(0.05);
    LED_Bright(2);
    wait(0.05);
    LED_Bright(3);
    wait(0.05);
    LED_Bright(4);
    wait(0.05);
    LED_Bright(3);
    wait(0.05);
    LED_Bright(2);
    wait(0.05);
    LED_Bright(1);
    wait(0.05);
    LED_Bright(0);
}

void LED_Bright(int led_num) {
    switch (led_num) {
        case 1:
            led1=1;
            led2=0;
            led3=0;
            led4=0;
            break;
        case 2:
            led1=0;
            led2=1;
            led3=0;
            led4=0;
            break;
        case 3:
            led1=0;
            led2=0;
            led3=1;
            led4=0;
            break;
        case 4:
            led1=0;
            led2=0;
            led3=0;
            led4=1;
            break;
        default:
            led1=0;
            led2=0;
            led3=0;
            led4=0;
            break;
    }
}


unsigned int readCard() {
    unsigned int id=0;
    int len,i;

    device.getc();//header
    device.getc();//header
    len = device.getc();

    char data[len];
    for (i=0;i<len;i++) {
        data[i]=device.getc();
    }
    if (data[0]==0x50) {//success
        for (i=0;i<4;i++) {
            id |= (data[4-i] << (i * 8));
        }
    } else {//failre
    }

    return id;
}

void print_member(struct member *p) {
    while (p != NULL) {
        pc.printf("%s %u\n", p->name,p->id);
        p = p->next;
    }
}

void free_member(struct member *p) {
    struct member *p2;

    while (p != NULL) {
        p2 = p->next;
        free(p);
        p = p2;
    }
}


struct member *add_member(char *name, int id, struct member *head) {
    struct member *p;

    p=create_member();
    p->id = id;
    strcpy(p->name, name);

    p->next = head;
    head = p;

    return head;
}

struct member *create_member(void) {
    struct member *p;

    if ((p = (struct member *) malloc(sizeof(struct member))) == NULL) {
        printf("malloc error\n");
        exit(EXIT_FAILURE);
    }
    p->enter = false;

    return p;
}

struct member * search_id(struct member *p,unsigned int id) {
    struct member *findp=NULL;
    while (p != NULL) {
        if (p->id==id) {
            findp = p;
            break;
        }
        p = p->next;
    }
    return findp;
}