#include "mbed.h"

#define DATA_SIZE 128*128
LocalFileSystem local("local");

DigitalOut CS(p21);
DigitalOut A0(p22);
DigitalOut E(p23);
DigitalOut WRB(p24);
DigitalOut RES(p25);

BusOut P1(p10, p11, p12, p13, p14, p15, p16, p17);

Timer t;

void WriteCOM(unsigned char a) {
    CS=0;
    E=1;
    A0=0;
    P1=a;
    WRB=0;
    WRB=1;
    CS=1;
}

void WriteDAT(unsigned char b) {
    CS=0;
    E=1;
    A0=1;
    P1=b;
    WRB=0;
    WRB=1;
    CS=1;
}

void init_lcd(void) {
    RES=1;
    wait_ms(100);
    RES=0;
    wait_ms(100);
    RES=1;
    wait_ms(120);

    WriteCOM(0x01);
    wait_ms(50);

    WriteCOM(0x11);//SLEEP OUT
    wait_ms(200);

    WriteCOM(0xFF);
    WriteDAT(0x40);
    WriteDAT(0x03);
    WriteDAT(0x1A);

    WriteCOM(0xd9);
    WriteDAT(0x60);
    WriteCOM(0xc7);
    WriteDAT(0x90);
    wait_ms(200);

    WriteCOM(0xB1);
    WriteDAT(0x04);
    WriteDAT(0x25);
    WriteDAT(0x18);

    WriteCOM(0xB2);
    WriteDAT(0x04);
    WriteDAT(0x25);
    WriteDAT(0x18);

    WriteCOM(0xB3);
    WriteDAT(0x04);
    WriteDAT(0x25);
    WriteDAT(0x18);
    WriteDAT(0x04);
    WriteDAT(0x25);
    WriteDAT(0x18);

    WriteCOM(0xB4);
    WriteDAT(0x03);

    WriteCOM(0xB6);
    WriteDAT(0x15);
    WriteDAT(0x02);

    WriteCOM(0xC0);// POWER CONTROL 1 GVDD&VCI1
    WriteDAT(0x02);
    WriteDAT(0x70);

    WriteCOM(0xC1);// POWER CONTROL 2 GVDD&VCI1
    WriteDAT(0x07);

    WriteCOM(0xC2);// POWER CONTROL 3 GVDD&VCI1
    WriteDAT(0x01);
    WriteDAT(0x01);

    WriteCOM(0xC3);// POWER CONTROL 4 GVDD&VCI1
    WriteDAT(0x02);
    WriteDAT(0x07);

    WriteCOM(0xC4);// POWER CONTROL 5 GVDD&VCI1
    WriteDAT(0x02);
    WriteDAT(0x04);

    WriteCOM(0xFC);// POWER CONTROL 6 GVDD&VCI1
    WriteDAT(0x11);
    WriteDAT(0x17);

    WriteCOM(0xC5);//VCOMH&VCOML
    WriteDAT(0x3c);
    WriteDAT(0x4f);

    WriteCOM(0x36);//MV,MX,MY,RGB
    WriteDAT(0x88);


    WriteCOM(0x3a);//GAMMA SET BY REGISTER
    WriteDAT(0x05);

//***********************GAMMA*************************
    WriteCOM(0xE0);
    WriteDAT(0x06);
    WriteDAT(0x0E);
    WriteDAT(0x05);
    WriteDAT(0x20);
    WriteDAT(0x27);
    WriteDAT(0x23);
    WriteDAT(0x1C);
    WriteDAT(0x21);
    WriteDAT(0x20);
    WriteDAT(0x1C);
    WriteDAT(0x26);
    WriteDAT(0x2F);
    WriteDAT(0x00);
    WriteDAT(0x03);
    WriteDAT(0x00);
    WriteDAT(0x24);

    WriteCOM(0xE1);
    WriteDAT(0x06);
    WriteDAT(0x10);
    WriteDAT(0x05);
    WriteDAT(0x21);
    WriteDAT(0x27);
    WriteDAT(0x22);
    WriteDAT(0x1C);
    WriteDAT(0x21);
    WriteDAT(0x1F);
    WriteDAT(0x1D);
    WriteDAT(0x27);
    WriteDAT(0x2F);
    WriteDAT(0x05);
    WriteDAT(0x03);
    WriteDAT(0x00);
    WriteDAT(0x3F);

//***************************RAM ADDRESS*******************
    WriteCOM(0x2A);
    WriteDAT(0x00);
    WriteDAT(0x02);
    WriteDAT(0x00);
    WriteDAT(0x81);

    WriteCOM(0x2B);
    WriteDAT(0x00);
    WriteDAT(0x03);
    WriteDAT(0x00);
    WriteDAT(0x82);

    WriteCOM(0x29);
    wait_ms(100);

    WriteCOM(0x2C);
}

int main() {
    FILE *fpi;
    int i;
    unsigned char  idat;
    unsigned char dat,dat2;

    init_lcd();

    if ((fpi=fopen("/local/sample.bmp", "rb")) == NULL) {
        fprintf(stderr, "input file open error\n");
        exit(1);
    }

    for (i=0;i<0x36;i++)//bitmap headder throw
        fread(&idat, sizeof(unsigned char), 1, fpi);

    for (i=0; i<DATA_SIZE; i++) {
        fread(&dat, sizeof(unsigned char), 1, fpi);
        fread(&dat2, sizeof(unsigned char), 1, fpi);
        
        dat2 = (dat2 << 1) | (dat >> 7);
        dat = ((dat & 0x60) << 1) | (dat & 0x1F);

        WriteDAT(dat2);
        WriteDAT(dat);
    }
    fclose(fpi);
}
