#include "mbed.h"
#include "EthernetNetIf.h"
#include "NtpClient.h"
#include "TextLCD.h"

TextLCD lcd(p6, p8, p13, p14, p15, p16); // rs, e, d0, d1, d2, d3

EthernetNetIf eth;
NtpClient ntp;

int main() {
    char buf[40];
    printf("\r\nSetting up...\r\n");
    lcd.printf("Setting up...\n");
    EthernetErr ethErr = eth.setup();
    if (ethErr) {
        printf("Error %d in setup.\n", ethErr);
        lcd.printf("Error %d in setup.\n", ethErr);
        return -1;
    }
    printf("\r\nSetup OK\r\n");

    time_t ctTime;
    ctTime = time(NULL);

    printf("\r\nCurrent time is : %s JST\r\n", ctime(&ctTime));
    lcd.printf("Timer setting...\n");
    Host server(IpAddr(), 123, "ntp.jst.mfeed.ad.jp");
    ntp.setTime(server);

    ctTime = time(NULL);
    ctTime += 32400; //set jst time
    strftime(buf,sizeof(buf), "%A %m/%d/%Y %H:%M:%S\n", localtime(&ctTime));
    printf("\r\nTime is now : %s JST\r\n", buf);

    while (1) {
        lcd.cls();
        ctTime = time(NULL);
        ctTime += 32400;
        strftime(buf,sizeof(buf), "%Y/%m/%d %a \n%H:%M:%S", localtime(&ctTime));
        printf("%s\n", buf);
        lcd.printf("%s", buf);

        wait(1);
    }

    return 0;

}
