#include"Sabertooth2x25.h"

Sabertooth2x25::Sabertooth2x25(PinName tx,int baudrate):device_(tx,NC){
    device_.baud(baudrate);
}

void Sabertooth2x25::sendCommand(int address, int command, int data) {
    checksum_ = (unsigned char)((address + command + data) & 0x7F);// checksum

    device_.putc((unsigned char)address);
    device_.putc((unsigned char)command);
    device_.putc((unsigned char)data);
    device_.putc(checksum_);
}

void Sabertooth2x25::forward_motor_1(int device_address, int speed) {
    sendCommand(device_address, DRIVE_FORWARD_MOTOR_ONE , speed);
}

void Sabertooth2x25::backward_motor_1(int device_address, int speed) {
    sendCommand(device_address, DRIVE_BACKWARD_MOTOR_ONE, speed);
}

void Sabertooth2x25::min_voltage(int device_address, int data) {
    sendCommand(device_address, MIN_VOLTAGE, data);
}

void Sabertooth2x25::max_voltage(int device_address, int data) {
    sendCommand(device_address, MAX_VOLTAGE, data);
}

void Sabertooth2x25::forward_motor_2(int device_address, int speed) {
    sendCommand(device_address, DRIVE_FORWARD_MOTOR_TWO, speed);
}

void Sabertooth2x25::backward_motor_2(int device_address, int speed) {
    sendCommand(device_address, DRIVE_BACKWARD_MOTOR_TWO, speed);
}

void Sabertooth2x25::drive_motor_1(int device_address, int speed) {
    sendCommand(device_address, DRIVE_MOTOR_ONE_7BIT , speed);
}

void Sabertooth2x25::drive_motor_2(int device_address, int speed) {
    sendCommand(device_address, DRIVE_MOTOR_TWO_7BIT, speed);
}

void Sabertooth2x25::drive_forward_mixed_mode(int device_address, int speed) {
    sendCommand(device_address, DRIVE_FORWARD_MIXED_MODE, speed);
}

void Sabertooth2x25::drive_backward_mixed_mode(int device_address, int speed) {
    sendCommand(device_address, DRIVE_BACKWARD_MIXED_MODE, speed);
}

void Sabertooth2x25::turn_right_mixed_mode(int device_address, int speed) {
    sendCommand(device_address, TURN_RIGHT_MIXED_MODE, speed);
}

void Sabertooth2x25::drive_turn_left_mixed_mode(int device_address, int speed) {
    sendCommand(device_address, DRIVE_TURN_LEFT_MIXED_MODE, speed);
}

void Sabertooth2x25::drive_forwards_back(int device_address, int speed) {
    sendCommand(device_address, DRIVE_FORWARD_BACK_7BIT, speed);
}

void Sabertooth2x25::turn(int device_address, int speed) {
    sendCommand(device_address, TURN_7BIT, speed);
}