/**
 * digitalInOut.pde
 * RTno is RT-middleware and arduino.
 *
 * Using RTno, arduino device can communicate any RT-components
 *  through the RTno-proxy component which is launched in PC.
 * Connect arduino with USB, and program with RTno library.
 * You do not have to define any protocols to establish communication
 *  between arduino and PC.
 *
 * Using RTno, you must not define the function "setup" and "loop".
 * Those functions are automatically defined in the RTno libarary.
 * You, developers, must define following functions:
 *  int onInitialize(void);
 *  int onActivated(void);
 *  int onDeactivated(void);
 *  int onExecute(void);
 *  int onError(void);
 *  int onReset(void);
 * These functions are spontaneously called by the RTno-proxy
 *  RT-component which is launched in the PC.
 */

#include "mbed.h"
#include "RTno.h"
#include "Serial.h"
DigitalIn inPorts[] = {(p5), (p6),(p7),(p8),(p9),(p10)};
DigitalOut outPorts[] = {(p15),(p16),(p17),(p18),(p19),(p20)};
DigitalOut leds[] = {(LED1),(LED2),(LED3),(LED4)};

/**
 * This function is called at first.
 * conf._default.baudrate: baudrate of serial communication
 * exec_cxt.periodic.type: reserved but not used.
 */
void rtcconf(void) {
    conf._default.baudrate = 115200;
    exec_cxt.periodic.type = ProxySynchronousExecutionContext;
}

/**
 * Declaration Division:
 *
 * DataPort and Data Buffer should be placed here.
 *
 * Currently, following 6 types are available.
 * TimedLong:
 * TimedDouble:
 * TimedFloat:
 * TimedLongSeq:
 * TimedDoubleSeq:
 * TimedFloatSeq:
 *
 * Please refer following comments. If you need to use some ports,
 * uncomment the line you want to declare.
 **/

TimedLongSeq led;
InPort ledIn("led", led);

TimedLongSeq in0;
InPort in0In("in0", in0);

TimedLongSeq out0;
OutPort out0Out("out0", out0);


//////////////////////////////////////////
// on_initialize
//
// This function is called in the initialization
// sequence. The sequence is triggered by the
// PC. When the RTnoRTC is launched in the PC,
// then, this function is remotely called
// through the USB cable.
// In on_initialize, usually DataPorts are added.
//
//////////////////////////////////////////
int RTno::onInitialize() {
    /* Data Ports are added in this section.
    */
    addInPort(ledIn);
    addInPort(in0In);
    addOutPort(out0Out);

    // Some initialization (like port direction setting)

    return RTC_OK;
}

////////////////////////////////////////////
// on_activated
// This function is called when the RTnoRTC
// is activated. When the activation, the RTnoRTC
// sends message to call this function remotely.
// If this function is failed (return value
// is RTC_ERROR), RTno will enter ERROR condition.
////////////////////////////////////////////
int RTno::onActivated() {
    // Write here initialization code.

    return RTC_OK;
}

/////////////////////////////////////////////
// on_deactivated
// This function is called when the RTnoRTC
// is deactivated.
/////////////////////////////////////////////
int RTno::onDeactivated() {
    // Write here finalization code.

    return RTC_OK;
}

//////////////////////////////////////////////
// This function is repeatedly called when the
// RTno is in the ACTIVE condition.
// If this function is failed (return value is
// RTC_ERROR), RTno immediately enter into the
// ERROR condition.r
//////////////////////////////////////////////
int RTno::onExecute() {

    /*
     * Input digital data
     */

    if (ledIn.isNew()) {
        ledIn.read();
        for (int i = 0; i < led.data.length() && i < 4; i++) {
            leds[i] =led.data[i];
        }
    }


        if (in0In.isNew()) {
            in0In.read();
            for (int i = 0; i < in0.data.length() && i < 6; i++) {
                outPorts[i] =in0.data[i];
            }
        }
    

    /*
     * Output digital data in Voltage unit.
     */
    out0.data.length(6);
    for (int i = 0; i < 6; i++) {
       out0.data[i] = inPorts[i];
    }
    out0Out.write();

    return RTC_OK;
}


//////////////////////////////////////
// on_error
// This function is repeatedly called when
// the RTno is in the ERROR condition.
// The ERROR condition can be recovered,
// when the RTno is reset.
///////////////////////////////////////
int RTno::onError() {
    return RTC_OK;
}

////////////////////////////////////////
// This function is called when
// the RTno is reset. If on_reset is
// succeeded, the RTno will enter into
// the INACTIVE condition. If failed
// (return value is RTC_ERROR), RTno
// will stay in ERROR condition.ec
///////////////////////////////////////
int RTno::onReset() {
    return RTC_OK;
}
